/*
 * Decompiled with CFR 0.152.
 */
package org.lime.velocircon;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.lime.velocircon.RconService;

public class Commands {
    public static void register(Object plugin, ProxyServer proxy, RconService rconService) {
        CommandManager commandManager = proxy.getCommandManager();
        List<LiteralArgumentBuilder<CommandSource>> commands = List.of(Commands.createCommand(rconService));
        commands.forEach(command -> {
            CommandMeta meta = commandManager.metaBuilder(command.getLiteral()).plugin(plugin).build();
            commandManager.register(meta, (Command)new BrigadierCommand(command.build()));
        });
    }

    private static LiteralArgumentBuilder<CommandSource> createCommand(RconService rconService) {
        return (LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder((String)"velocircon").then(((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder((String)"reload").requires(source -> source.hasPermission("velocircon.reload"))).executes(context -> {
            CommandSource source = (CommandSource)context.getSource();
            try {
                rconService.reloadConfig().get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            source.sendMessage((Component)Component.text((String)"Config reloaded"));
            return 1;
        }));
    }
}

