/*
 * Decompiled with CFR 0.152.
 */
package com.clipsezt.teleport;

import com.clipsezt.teleport.TeleportRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class RequestManager {
    private final Map<UUID, List<TeleportRequest>> incoming = new HashMap<UUID, List<TeleportRequest>>();
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final long expiryMillis;
    private final long cooldownMillis;

    public RequestManager(long expirySeconds, long cooldownSeconds) {
        this.expiryMillis = expirySeconds * 1000L;
        this.cooldownMillis = cooldownSeconds * 1000L;
    }

    public boolean canSend(Player sender) {
        Long last = this.cooldowns.get(sender.getUniqueId());
        return last == null || System.currentTimeMillis() - last >= this.cooldownMillis;
    }

    public long getRemaining(Player sender) {
        Long last = this.cooldowns.get(sender.getUniqueId());
        if (last == null) {
            return 0L;
        }
        long diff = System.currentTimeMillis() - last;
        return (this.cooldownMillis - diff) / 1000L;
    }

    public void create(Player sender, Player target) {
        this.cooldowns.put(sender.getUniqueId(), System.currentTimeMillis());
        this.incoming.computeIfAbsent(target.getUniqueId(), x -> new ArrayList()).add(new TeleportRequest(sender.getUniqueId(), target.getUniqueId(), System.currentTimeMillis()));
    }

    public TeleportResult pop(UUID targetId) {
        List<TeleportRequest> list = this.incoming.get(targetId);
        if (list == null || list.isEmpty()) {
            return new TeleportResult(TeleportStatus.NONE, null);
        }
        long now = System.currentTimeMillis();
        int i = list.size() - 1;
        if (i >= 0) {
            TeleportRequest req = list.get(i);
            Player sender = Bukkit.getPlayer((UUID)req.getSender());
            if (sender == null || !sender.isOnline() || now - req.getCreatedAt() > this.expiryMillis) {
                list.remove(i);
                return new TeleportResult(TeleportStatus.EXPIRED, null);
            }
            list.remove(i);
            return new TeleportResult(TeleportStatus.OK, req);
        }
        return new TeleportResult(TeleportStatus.NONE, null);
    }

    public void clear() {
        this.incoming.clear();
        this.cooldowns.clear();
    }

    public static class TeleportResult {
        private final TeleportStatus status;
        private final TeleportRequest request;

        public TeleportResult(TeleportStatus status, TeleportRequest req) {
            this.status = status;
            this.request = req;
        }

        public TeleportStatus getStatus() {
            return this.status;
        }

        public TeleportRequest getRequest() {
            return this.request;
        }
    }

    public static enum TeleportStatus {
        NONE,
        EXPIRED,
        OK;

    }
}

