/*
 * Decompiled with CFR 0.152.
 */
package com.clipsezt.commands;

import com.clipsezt.ClipsEZTPlugin;
import com.clipsezt.teleport.RequestManager;
import com.clipsezt.util.Messages;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TpaCommand
implements CommandExecutor {
    private final ClipsEZTPlugin plugin;
    private final RequestManager manager;
    private final Messages msg;

    public TpaCommand(ClipsEZTPlugin plugin) {
        this.plugin = plugin;
        this.manager = plugin.getRequestManager();
        this.msg = plugin.getMessages();
    }

    public boolean onCommand(CommandSender s, Command cmd, String label, String[] args) {
        if (!(s instanceof Player)) {
            this.msg.send(s, "not-player", new String[0]);
            return true;
        }
        Player sender = (Player)s;
        if (!sender.hasPermission("clipsezt.tpa")) {
            this.msg.send((CommandSender)sender, "tpa-no-permission", new String[0]);
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage("\u00a7cUsage: /tpa <player>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            this.msg.send((CommandSender)sender, "tpa-no-player", new String[0]);
            return true;
        }
        if (target == sender) {
            this.msg.send((CommandSender)sender, "tpa-self", new String[0]);
            return true;
        }
        if (!this.manager.canSend(sender)) {
            this.msg.send((CommandSender)sender, "tpa-cooldown", "%seconds%", String.valueOf(this.manager.getRemaining(sender)));
            return true;
        }
        this.manager.create(sender, target);
        this.msg.send((CommandSender)sender, "tpa-sent", "%target%", target.getName());
        this.msg.send((CommandSender)target, "tpa-received", "%sender%", sender.getName());
        return true;
    }
}

