/*
 * Decompiled with CFR 0.152.
 */
package com.clipsezt.commands;

import com.clipsezt.ClipsEZTPlugin;
import com.clipsezt.teleport.RequestManager;
import com.clipsezt.util.Messages;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TpAcceptCommand
implements CommandExecutor {
    private final RequestManager manager;
    private final Messages msg;

    public TpAcceptCommand(ClipsEZTPlugin plugin) {
        this.manager = plugin.getRequestManager();
        this.msg = plugin.getMessages();
    }

    public boolean onCommand(CommandSender s, Command c, String l, String[] a) {
        if (!(s instanceof Player)) {
            this.msg.send(s, "not-player", new String[0]);
            return true;
        }
        Player target = (Player)s;
        RequestManager.TeleportResult result = this.manager.pop(target.getUniqueId());
        switch (result.getStatus()) {
            case NONE: {
                this.msg.send((CommandSender)target, "tpa-no-requests", new String[0]);
                return true;
            }
            case EXPIRED: {
                this.msg.send((CommandSender)target, "tpa-expired", new String[0]);
                return true;
            }
        }
        Player sender = Bukkit.getPlayer((UUID)result.getRequest().getSender());
        if (sender == null) {
            this.msg.send((CommandSender)target, "tpa-expired", new String[0]);
            return true;
        }
        sender.teleport(target.getLocation());
        this.msg.send((CommandSender)target, "tpa-accepted-target", "%sender%", sender.getName());
        this.msg.send((CommandSender)sender, "tpa-accepted-sender", "%target%", target.getName());
        return true;
    }
}

