/*
 * Decompiled with CFR 0.152.
 */
package com.clipsezt;

import com.clipsezt.commands.TpAcceptCommand;
import com.clipsezt.commands.TpDenyCommand;
import com.clipsezt.commands.TpForceCommand;
import com.clipsezt.commands.TpaCommand;
import com.clipsezt.teleport.PlayerListener;
import com.clipsezt.teleport.RequestManager;
import com.clipsezt.util.Messages;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ClipsEZTPlugin
extends JavaPlugin {
    private static ClipsEZTPlugin instance;
    private RequestManager requestManager;
    private Messages messages;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.messages = new Messages(this);
        long expiry = this.getConfig().getLong("settings.request-expiry-seconds");
        long cooldown = this.getConfig().getLong("settings.request-cooldown-seconds");
        this.requestManager = new RequestManager(expiry, cooldown);
        this.getCommand("tpa").setExecutor((CommandExecutor)new TpaCommand(this));
        this.getCommand("tpaccept").setExecutor((CommandExecutor)new TpAcceptCommand(this));
        this.getCommand("tpdeny").setExecutor((CommandExecutor)new TpDenyCommand(this));
        TpForceCommand force = new TpForceCommand(this);
        this.getCommand("tpforce").setExecutor((CommandExecutor)force);
        this.getCommand("tpforce").setTabCompleter((TabCompleter)force);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getLogger().info("ClipsEZT enabled!");
    }

    public void onDisable() {
        this.requestManager.clear();
    }

    public static ClipsEZTPlugin getInstance() {
        return instance;
    }

    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    public Messages getMessages() {
        return this.messages;
    }
}

