/*
 * Decompiled with CFR 0.152.
 */
package com.clippyclip.clipsezrtp.util;

import com.clippyclip.clipsezrtp.ClipsEZRTP;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;

public class MessagesManager {
    private final ClipsEZRTP plugin;
    private String prefix;
    private final Map<String, String> messages = new HashMap<String, String>();

    public MessagesManager(ClipsEZRTP plugin) {
        this.plugin = plugin;
        this.load();
    }

    public void load() {
        this.messages.clear();
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("messages");
        if (section != null) {
            for (String key : section.getKeys(false)) {
                if (key.equals("prefix")) {
                    this.prefix = this.color(section.getString(key));
                    continue;
                }
                this.messages.put(key, this.color(section.getString(key)));
            }
        }
        if (this.prefix == null) {
            this.prefix = "";
        }
    }

    public String getMessage(String key) {
        return this.prefix + this.messages.getOrDefault(key, "");
    }

    public String format(String key, Map<String, String> placeholders) {
        String msg = this.getMessage(key);
        for (String ph : placeholders.keySet()) {
            msg = msg.replace("%" + ph + "%", placeholders.get(ph));
        }
        return msg;
    }

    private String color(String msg) {
        if (msg == null) {
            return "";
        }
        String colored = ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
        return colored;
    }
}

