/*
 * Decompiled with CFR 0.152.
 */
package com.clippyclip.clipsezrtp.rtp;

import com.clippyclip.clipsezrtp.ClipsEZRTP;
import com.clippyclip.clipsezrtp.config.ConfigManager;
import com.clippyclip.clipsezrtp.hooks.CombatTagHook;
import com.clippyclip.clipsezrtp.hooks.WorldGuardHook;
import com.clippyclip.clipsezrtp.rtp.SafeLocationFinder;
import com.clippyclip.clipsezrtp.util.MessagesManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class RTPManager
implements CommandExecutor,
TabCompleter,
Listener {
    private final ClipsEZRTP plugin;
    private final ConfigManager configManager;
    private final MessagesManager messagesManager;
    private final SafeLocationFinder safeLocationFinder;
    private final WorldGuardHook worldGuardHook;
    private final CombatTagHook combatTagHook;
    private final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, PendingTeleport> pendingTeleports = new ConcurrentHashMap<UUID, PendingTeleport>();

    public RTPManager(ClipsEZRTP plugin, ConfigManager configManager, MessagesManager messagesManager, WorldGuardHook worldGuardHook, CombatTagHook combatTagHook) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.messagesManager = messagesManager;
        this.safeLocationFinder = new SafeLocationFinder(configManager);
        this.worldGuardHook = worldGuardHook;
        this.combatTagHook = combatTagHook;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        double cost;
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("clips.rtp.use")) {
            player.sendMessage("\u00a7cYou do not have permission to use this command.");
            return true;
        }
        World world = player.getWorld();
        if (!this.configManager.isWorldEnabled(world.getName())) {
            player.sendMessage(this.messagesManager.getMessage("disabled-world"));
            return true;
        }
        if (this.pendingTeleports.containsKey(player.getUniqueId())) {
            player.sendMessage(this.messagesManager.getMessage("already-teleporting"));
            return true;
        }
        if (!player.hasPermission("clips.rtp.bypass.combat") && this.combatTagHook != null && this.combatTagHook.isAvailable() && this.combatTagHook.isInCombat(player)) {
            player.sendMessage(this.messagesManager.getMessage("combat-blocked"));
            return true;
        }
        if (!player.hasPermission("clips.rtp.bypass.cooldown") && !this.checkCooldown(player)) {
            long remaining = this.getRemainingCooldown(player);
            HashMap<String, String> ph = new HashMap<String, String>();
            ph.put("time", String.valueOf(remaining));
            player.sendMessage(this.messagesManager.format("cooldown", ph));
            return true;
        }
        Economy econ = this.plugin.getEconomy();
        if (!player.hasPermission("clips.rtp.bypass.cost") && this.plugin.isEconomyEnabled() && econ != null && this.configManager.isUseEconomy() && (cost = this.configManager.getCost()) > 0.0 && econ.getBalance((OfflinePlayer)player) < cost) {
            HashMap<String, String> ph = new HashMap<String, String>();
            ph.put("cost", String.format(Locale.US, "%.2f", cost));
            player.sendMessage(this.messagesManager.format("not-enough-money", ph));
            return true;
        }
        this.startTeleportDelay(player);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return Collections.emptyList();
    }

    private boolean checkCooldown(Player player) {
        long now = System.currentTimeMillis();
        Long nextAllowed = this.cooldowns.get(player.getUniqueId());
        return nextAllowed == null || now >= nextAllowed;
    }

    private long getRemainingCooldown(Player player) {
        Long nextAllowed = this.cooldowns.get(player.getUniqueId());
        if (nextAllowed == null) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long diff = nextAllowed - now;
        if (diff < 0L) {
            return 0L;
        }
        return diff / 1000L;
    }

    private void setCooldown(Player player) {
        int seconds = this.configManager.getCooldownSeconds();
        if (seconds <= 0) {
            return;
        }
        long next = System.currentTimeMillis() + (long)seconds * 1000L;
        this.cooldowns.put(player.getUniqueId(), next);
    }

    private void startTeleportDelay(Player player) {
        int delaySeconds = this.configManager.getTeleportDelaySeconds();
        boolean movementCancel = this.configManager.isMovementCancelEnabled();
        HashMap<String, String> ph = new HashMap<String, String>();
        ph.put("delay", String.valueOf(delaySeconds));
        player.sendMessage(this.messagesManager.format("teleporting", ph));
        BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.performRTP(player), (long)delaySeconds * 20L);
        if (movementCancel) {
            this.pendingTeleports.put(player.getUniqueId(), new PendingTeleport(task));
        }
    }

    private void cancelPendingTeleport(Player player, boolean sendMessage) {
        PendingTeleport pending = this.pendingTeleports.remove(player.getUniqueId());
        if (pending != null) {
            pending.task.cancel();
            if (sendMessage) {
                player.sendMessage(this.messagesManager.getMessage("teleport-cancelled"));
            }
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        PendingTeleport pending = this.pendingTeleports.get(player.getUniqueId());
        if (pending == null) {
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        if (to == null) {
            return;
        }
        if (from.getBlockX() != to.getBlockX() || from.getBlockY() != to.getBlockY() || from.getBlockZ() != to.getBlockZ()) {
            this.cancelPendingTeleport(player, true);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        PendingTeleport pending = this.pendingTeleports.remove(player.getUniqueId());
        if (pending != null) {
            pending.task.cancel();
        }
    }

    private void performRTP(Player player) {
        PendingTeleport pending;
        if (this.configManager.isMovementCancelEnabled() && (pending = this.pendingTeleports.remove(player.getUniqueId())) == null) {
            return;
        }
        if (!player.isOnline()) {
            return;
        }
        if (!player.hasPermission("clips.rtp.bypass.combat") && this.combatTagHook != null && this.combatTagHook.isAvailable() && this.combatTagHook.isInCombat(player)) {
            player.sendMessage(this.messagesManager.getMessage("combat-blocked"));
            return;
        }
        World world = player.getWorld();
        this.safeLocationFinder.findSafeLocation(world, location -> player.hasPermission("clips.rtp.bypass.worldguard") || this.worldGuardHook == null || !this.worldGuardHook.isAvailable() || this.worldGuardHook.isAllowed(player, (Location)location), location -> {
            double cost;
            if (!player.hasPermission("clips.rtp.bypass.worldguard") && this.worldGuardHook != null && this.worldGuardHook.isAvailable() && !this.worldGuardHook.isAllowed(player, (Location)location)) {
                player.sendMessage(this.messagesManager.getMessage("worldguard-blocked"));
                return;
            }
            Economy econ = this.plugin.getEconomy();
            if (!player.hasPermission("clips.rtp.bypass.cost") && this.plugin.isEconomyEnabled() && econ != null && this.configManager.isUseEconomy() && (cost = this.configManager.getCost()) > 0.0) {
                if (econ.getBalance((OfflinePlayer)player) < cost) {
                    HashMap<String, String> ph = new HashMap<String, String>();
                    ph.put("cost", String.format(Locale.US, "%.2f", cost));
                    player.sendMessage(this.messagesManager.format("not-enough-money", ph));
                    return;
                }
                econ.withdrawPlayer((OfflinePlayer)player, cost);
            }
            player.teleport(location);
            if (!player.hasPermission("clips.rtp.bypass.cooldown")) {
                this.setCooldown(player);
            }
            HashMap<String, String> ph = new HashMap<String, String>();
            ph.put("x", String.format(Locale.US, "%.1f", location.getX()));
            ph.put("y", String.format(Locale.US, "%.1f", location.getY()));
            ph.put("z", String.format(Locale.US, "%.1f", location.getZ()));
            player.sendMessage(this.messagesManager.format("rtp-success", ph));
        }, () -> player.sendMessage(this.messagesManager.getMessage("safe-location-not-found")));
    }

    private static class PendingTeleport {
        private final BukkitTask task;

        private PendingTeleport(BukkitTask task) {
            this.task = task;
        }
    }
}

