/*
 * Decompiled with CFR 0.152.
 */
package com.clippyclip.clipsezrtp.hooks;

import com.clippyclip.clipsezrtp.ClipsEZRTP;
import com.clippyclip.clipsezrtp.config.ConfigManager;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class WorldGuardHook {
    private final ClipsEZRTP plugin;
    private final ConfigManager config;
    private boolean available;
    private Object worldGuardInstance;
    private Object flag;
    private Method getFlagRegistryMethod;
    private Method getRegionContainerMethod;
    private Method createQueryMethod;
    private Method getApplicableRegionsMethod;
    private Method queryStateMethod;

    public WorldGuardHook(ClipsEZRTP plugin, ConfigManager config) {
        this.plugin = plugin;
        this.config = config;
    }

    public void setup() {
        if (!this.config.isWorldGuardEnabled()) {
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") == null) {
            return;
        }
        try {
            this.initReflection();
            this.available = true;
            this.plugin.getLogger().info("WorldGuard hook enabled (safe reflection mode).");
        }
        catch (Throwable t) {
            this.available = false;
            this.plugin.getLogger().warning("WorldGuard found but could not hook safely. RTP will ignore WG.");
        }
    }

    private void initReflection() throws Exception {
        Class<?> wgClass = Class.forName("com.sk89q.worldguard.WorldGuard");
        this.worldGuardInstance = wgClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        this.getFlagRegistryMethod = wgClass.getMethod("getFlagRegistry", new Class[0]);
        Object registry = this.getFlagRegistryMethod.invoke(this.worldGuardInstance, new Object[0]);
        Class<?> stateFlagClass = Class.forName("com.sk89q.worldguard.protection.flags.StateFlag");
        Class<?> flagClass = Class.forName("com.sk89q.worldguard.protection.flags.Flag");
        String flagName = this.config.getWorldGuardFlagName();
        Method getFlagMethod = registry.getClass().getMethod("get", String.class);
        Object existingFlag = getFlagMethod.invoke(registry, flagName);
        if (existingFlag != null && stateFlagClass.isInstance(existingFlag)) {
            this.flag = existingFlag;
        } else {
            Object newFlag = stateFlagClass.getConstructor(String.class, Boolean.TYPE).newInstance(flagName, true);
            Method registerMethod = registry.getClass().getMethod("register", flagClass);
            registerMethod.invoke(registry, newFlag);
            this.flag = newFlag;
        }
        Object platform = wgClass.getMethod("getPlatform", new Class[0]).invoke(this.worldGuardInstance, new Object[0]);
        this.getRegionContainerMethod = platform.getClass().getMethod("getRegionContainer", new Class[0]);
        Object container = this.getRegionContainerMethod.invoke(platform, new Object[0]);
        this.createQueryMethod = container.getClass().getMethod("createQuery", new Class[0]);
        Object query = this.createQueryMethod.invoke(container, new Object[0]);
        this.getApplicableRegionsMethod = query.getClass().getMethod("getApplicableRegions", Class.forName("com.sk89q.worldedit.util.Location"));
        this.queryStateMethod = Class.forName("com.sk89q.worldguard.protection.ApplicableRegionSet").getMethod("queryState", Class.forName("com.sk89q.worldguard.LocalPlayer"), stateFlagClass);
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isAllowed(Player player, Location location) {
        if (!this.available) {
            return true;
        }
        try {
            Class<?> bukkitAdapter = Class.forName("com.sk89q.worldedit.bukkit.BukkitAdapter");
            Object weLocation = bukkitAdapter.getMethod("adapt", Location.class).invoke(null, location);
            Object platform = this.worldGuardInstance.getClass().getMethod("getPlatform", new Class[0]).invoke(this.worldGuardInstance, new Object[0]);
            Object container = this.getRegionContainerMethod.invoke(platform, new Object[0]);
            Object query = this.createQueryMethod.invoke(container, new Object[0]);
            Object regions = this.getApplicableRegionsMethod.invoke(query, weLocation);
            Class<?> wgPlugin = Class.forName("com.sk89q.worldguard.bukkit.WorldGuardPlugin");
            Object wgInst = wgPlugin.getMethod("inst", new Class[0]).invoke(null, new Object[0]);
            Object localPlayer = wgPlugin.getMethod("wrapPlayer", Player.class).invoke(wgInst, player);
            Object state = this.queryStateMethod.invoke(regions, localPlayer, this.flag);
            if (state == null) {
                return !this.config.isWorldGuardRequireAllow();
            }
            String name = state.toString();
            if (this.config.isWorldGuardRequireAllow()) {
                return name.equals("ALLOW");
            }
            return !name.equals("DENY");
        }
        catch (Throwable t) {
            return true;
        }
    }
}

