/*
 * Decompiled with CFR 0.152.
 */
package com.clippyclip.clipsezrtp.hooks;

import com.clippyclip.clipsezrtp.ClipsEZRTP;
import com.clippyclip.clipsezrtp.config.ConfigManager;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public final class CombatTagHook {
    private final ClipsEZRTP plugin;
    private final ConfigManager config;
    private boolean available;
    private boolean loggedReflectionFailure;

    public CombatTagHook(ClipsEZRTP plugin, ConfigManager config) {
        this.plugin = plugin;
        this.config = config;
    }

    public void setup() {
        this.available = this.config.isCombatBlockEnabled();
        if (this.available) {
            this.plugin.getLogger().info("Combat-tag blocking enabled.");
        }
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isInCombat(Player player) {
        if (!this.available || player == null) {
            return false;
        }
        for (String pluginName : this.config.getCombatSupportedPlugins()) {
            Boolean r;
            if (pluginName == null || pluginName.isBlank() || Bukkit.getPluginManager().getPlugin(pluginName) == null || (r = this.tryKnownPlugin(pluginName.trim(), player)) == null) continue;
            return r;
        }
        for (String key : this.config.getCombatMetadataKeys()) {
            if (key == null || key.isBlank() || !player.hasMetadata(key)) continue;
            try {
                for (MetadataValue v : player.getMetadata(key)) {
                    if (v == null) continue;
                    try {
                        if (!v.asBoolean()) continue;
                        return true;
                    }
                    catch (Throwable ignored) {
                        String s = v.asString();
                        if (s == null || s.isBlank() || "false".equalsIgnoreCase(s) || "0".equals(s)) continue;
                        return true;
                    }
                }
            }
            catch (Throwable throwable) {
            }
        }
        try {
            for (String tag : this.config.getCombatScoreboardTags()) {
                if (tag == null || tag.isBlank() || !player.getScoreboardTags().contains(tag)) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private Boolean tryKnownPlugin(String pluginName, Player player) {
        block26: {
            try {
                if (pluginName.equalsIgnoreCase("CombatLogX")) {
                    block25: {
                        Object r3;
                        Plugin pl = Bukkit.getPluginManager().getPlugin("CombatLogX");
                        if (pl == null) {
                            return null;
                        }
                        Object combatManager = null;
                        try {
                            combatManager = pl.getClass().getMethod("getCombatManager", new Class[0]).invoke((Object)pl, new Object[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        if (combatManager != null) {
                            try {
                                Object r2 = combatManager.getClass().getMethod("isInCombat", Player.class).invoke(combatManager, player);
                                if (r2 instanceof Boolean) {
                                    Boolean b = (Boolean)r2;
                                    return b;
                                }
                            }
                            catch (NoSuchMethodException ignored) {
                                try {
                                    r3 = combatManager.getClass().getMethod("isInCombat", UUID.class).invoke(combatManager, player.getUniqueId());
                                    if (r3 instanceof Boolean) {
                                        Boolean b = (Boolean)r3;
                                        return b;
                                    }
                                }
                                catch (NoSuchMethodException r3) {
                                    // empty catch block
                                }
                            }
                        }
                        try {
                            Object api = pl.getClass().getMethod("getAPI", new Class[0]).invoke((Object)pl, new Object[0]);
                            if (api == null) break block25;
                            try {
                                r3 = api.getClass().getMethod("isInCombat", Player.class).invoke(api, player);
                                if (r3 instanceof Boolean) {
                                    Boolean b = (Boolean)r3;
                                    return b;
                                }
                            }
                            catch (NoSuchMethodException r4) {}
                        }
                        catch (NoSuchMethodException api) {
                            // empty catch block
                        }
                    }
                    return null;
                }
                if (!pluginName.equalsIgnoreCase("PvPManager")) break block26;
                Plugin pl = Bukkit.getPluginManager().getPlugin("PvPManager");
                if (pl == null) {
                    return null;
                }
                Object handler = null;
                try {
                    handler = pl.getClass().getMethod("getPlayerHandler", new Class[0]).invoke((Object)pl, new Object[0]);
                }
                catch (NoSuchMethodException api) {
                    // empty catch block
                }
                if (handler != null) {
                    try {
                        Object r = handler.getClass().getMethod("isInCombat", Player.class).invoke(handler, player);
                        if (r instanceof Boolean) {
                            Boolean b = (Boolean)r;
                            return b;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                return null;
            }
            catch (Throwable t) {
                if (this.loggedReflectionFailure) break block26;
                this.loggedReflectionFailure = true;
                this.plugin.getLogger().warning("Combat-tag hook reflection check failed; falling back to metadata/tags.");
            }
        }
        return null;
    }
}

