/*
 * Decompiled with CFR 0.152.
 */
package com.clippyclip.clipsezrtp.config;

import com.clippyclip.clipsezrtp.ClipsEZRTP;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final ClipsEZRTP plugin;
    private FileConfiguration config;

    public ConfigManager(ClipsEZRTP plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public boolean isUseEconomy() {
        return this.config.getBoolean("use-economy", true);
    }

    public int getCooldownSeconds() {
        return this.config.getInt("cooldown-seconds", 60);
    }

    public int getTeleportDelaySeconds() {
        return this.config.getInt("teleport-delay-seconds", 3);
    }

    public boolean isMovementCancelEnabled() {
        return this.config.getBoolean("movement-cancel", true);
    }

    public int getMinRadius() {
        return this.config.getInt("min-radius");
    }

    public int getMaxRadius() {
        return this.config.getInt("max-radius");
    }

    public boolean isAllowCaves() {
        return this.config.getBoolean("allow-caves", false);
    }

    public Set<String> getEnabledWorlds() {
        return new HashSet<String>(this.config.getStringList("enabled-worlds"));
    }

    public boolean isWorldEnabled(String world) {
        return this.getEnabledWorlds().contains(world);
    }

    public World getDefaultWorld() {
        return Bukkit.getWorld((String)this.config.getString("world", "world"));
    }

    public double getCost() {
        return this.config.getDouble("cost", 0.0);
    }

    public boolean isWorldGuardEnabled() {
        return this.config.getBoolean("worldguard.enabled", false);
    }

    public String getWorldGuardFlagName() {
        return this.config.getString("worldguard.flag-name", "clipsezrtp");
    }

    public boolean isWorldGuardRequireAllow() {
        return this.config.getBoolean("worldguard.require-allow", false);
    }

    public boolean isCombatBlockEnabled() {
        return this.config.getBoolean("combat-tag.enabled", false);
    }

    public List<String> getCombatSupportedPlugins() {
        return this.config.getStringList("combat-tag.supported-plugins");
    }

    public List<String> getCombatMetadataKeys() {
        return this.config.getStringList("combat-tag.metadata-keys");
    }

    public List<String> getCombatScoreboardTags() {
        return this.config.getStringList("combat-tag.scoreboard-tags");
    }
}

