/*
 * Decompiled with CFR 0.152.
 */
package com.clippyclip.clipsezrtp;

import com.clippyclip.clipsezrtp.config.ConfigManager;
import com.clippyclip.clipsezrtp.hooks.CombatTagHook;
import com.clippyclip.clipsezrtp.hooks.WorldGuardHook;
import com.clippyclip.clipsezrtp.rtp.RTPManager;
import com.clippyclip.clipsezrtp.util.MessagesManager;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class ClipsEZRTP
extends JavaPlugin {
    private static ClipsEZRTP instance;
    private ConfigManager configManager;
    private MessagesManager messagesManager;
    private RTPManager rtpManager;
    private WorldGuardHook worldGuardHook;
    private CombatTagHook combatTagHook;
    private Economy economy;
    private boolean economyEnabled;

    public static ClipsEZRTP getInstance() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.configManager = new ConfigManager(this);
        this.messagesManager = new MessagesManager(this);
        this.worldGuardHook = new WorldGuardHook(this, this.configManager);
        this.worldGuardHook.setup();
        this.combatTagHook = new CombatTagHook(this, this.configManager);
        this.combatTagHook.setup();
        this.rtpManager = new RTPManager(this, this.configManager, this.messagesManager, this.worldGuardHook, this.combatTagHook);
        this.setupEconomy();
        if (this.getCommand("rtp") != null) {
            this.getCommand("rtp").setExecutor((CommandExecutor)this.rtpManager);
            this.getCommand("rtp").setTabCompleter((TabCompleter)this.rtpManager);
        }
        Bukkit.getPluginManager().registerEvents((Listener)this.rtpManager, (Plugin)this);
        this.getLogger().info("ClipsEZRTP enabled.");
    }

    public void onDisable() {
        this.getLogger().info("ClipsEZRTP disabled.");
    }

    private void setupEconomy() {
        if (!this.configManager.isUseEconomy()) {
            this.economyEnabled = false;
            return;
        }
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.economyEnabled = false;
            return;
        }
        RegisteredServiceProvider provider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (provider == null) {
            this.economyEnabled = false;
            return;
        }
        this.economy = (Economy)provider.getProvider();
        this.economyEnabled = this.economy != null;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public MessagesManager getMessagesManager() {
        return this.messagesManager;
    }

    public RTPManager getRtpManager() {
        return this.rtpManager;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public boolean isEconomyEnabled() {
        return this.economyEnabled;
    }
}

