/*
 * Decompiled with CFR 0.152.
 */
package me.clipsezh.clipsezh.home;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.clipsezh.clipsezh.ClipsEZHPlugin;
import me.clipsezh.clipsezh.home.Home;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class HomeManager {
    private final ClipsEZHPlugin plugin;
    private final File dataFolder;
    private final Map<UUID, Map<String, Home>> cache = new HashMap<UUID, Map<String, Home>>();

    public HomeManager(ClipsEZHPlugin plugin) {
        this.plugin = plugin;
        this.dataFolder = new File(plugin.getDataFolder(), "data");
    }

    private File getFile(UUID uuid) {
        return new File(this.dataFolder, uuid.toString() + ".yml");
    }

    private Map<String, Home> load(UUID uuid) {
        YamlConfiguration cfg;
        ConfigurationSection sec;
        if (this.cache.containsKey(uuid)) {
            return this.cache.get(uuid);
        }
        File file = this.getFile(uuid);
        HashMap<String, Home> homes = new HashMap<String, Home>();
        if (file.exists() && (sec = (cfg = YamlConfiguration.loadConfiguration((File)file)).getConfigurationSection("homes")) != null) {
            for (String key : sec.getKeys(false)) {
                String world = sec.getString(key + ".world");
                double x = sec.getDouble(key + ".x");
                double y = sec.getDouble(key + ".y");
                double z = sec.getDouble(key + ".z");
                float yaw = (float)sec.getDouble(key + ".yaw");
                float pitch = (float)sec.getDouble(key + ".pitch");
                homes.put(key, new Home(key, world, x, y, z, yaw, pitch));
            }
        }
        this.cache.put(uuid, homes);
        return homes;
    }

    private void save(UUID uuid, Map<String, Home> homes) {
        File file = this.getFile(uuid);
        YamlConfiguration cfg = new YamlConfiguration();
        for (Map.Entry<String, Home> entry : homes.entrySet()) {
            Home h = entry.getValue();
            cfg.set("homes." + entry.getKey() + ".world", (Object)h.toLocation().getWorld().getName());
            cfg.set("homes." + entry.getKey() + ".x", (Object)h.toLocation().getX());
            cfg.set("homes." + entry.getKey() + ".y", (Object)h.toLocation().getY());
            cfg.set("homes." + entry.getKey() + ".z", (Object)h.toLocation().getZ());
            cfg.set("homes." + entry.getKey() + ".yaw", (Object)Float.valueOf(h.toLocation().getYaw()));
            cfg.set("homes." + entry.getKey() + ".pitch", (Object)Float.valueOf(h.toLocation().getPitch()));
        }
        try {
            cfg.save(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.cache.put(uuid, homes);
    }

    public Home getHome(UUID uuid, String name) {
        return this.load(uuid).get(name);
    }

    public List<String> getHomeNames(UUID uuid) {
        return new ArrayList<String>(this.load(uuid).keySet());
    }

    public boolean deleteHome(UUID uuid, String name) {
        Map<String, Home> homes = this.load(uuid);
        if (!homes.containsKey(name)) {
            return false;
        }
        homes.remove(name);
        this.save(uuid, homes);
        return true;
    }

    public boolean setHome(Player player, String name) {
        UUID uuid = player.getUniqueId();
        Map<String, Home> homes = this.load(uuid);
        boolean exists = homes.containsKey(name);
        int max = this.getMaxHomes(player);
        if (!exists && max != -1 && homes.size() >= max) {
            return false;
        }
        homes.put(name, new Home(name, player.getLocation()));
        this.save(uuid, homes);
        return true;
    }

    public int getMaxHomes(Player player) {
        int defaultMax;
        int limit = defaultMax = this.plugin.getConfig().getInt("default-max-homes");
        for (PermissionAttachmentInfo perm : player.getEffectivePermissions()) {
            if (!perm.getValue() || !perm.getPermission().startsWith("clipsezh.limit.")) continue;
            try {
                int val = Integer.parseInt(perm.getPermission().split("\\.")[2]);
                limit = Math.max(limit, val);
            }
            catch (Exception exception) {}
        }
        return limit;
    }
}

