/*
 * Decompiled with CFR 0.152.
 */
package me.clipsezh.clipsezh.commands;

import java.util.List;
import java.util.Map;
import me.clipsezh.clipsezh.ClipsEZHPlugin;
import me.clipsezh.clipsezh.home.Home;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class HomeCommand
implements CommandExecutor,
TabCompleter {
    private final ClipsEZHPlugin plugin;

    public HomeCommand(ClipsEZHPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.sendMessage(sender, "player-only");
            return true;
        }
        Player p = (Player)sender;
        if (args.length != 1) {
            this.plugin.sendMessage((CommandSender)p, "usage-home");
            return true;
        }
        String name = args[0];
        Home home = this.plugin.getHomeManager().getHome(p.getUniqueId(), name);
        if (home == null) {
            this.plugin.sendMessage((CommandSender)p, "home-not-found", Map.of("home", name));
            return true;
        }
        int delay = this.plugin.getTeleportDelay();
        boolean bypass = p.hasPermission("clipsezh.bypass.delay");
        if (delay <= 0 || bypass) {
            p.teleport(home.toLocation());
            this.plugin.sendMessage((CommandSender)p, "teleported", Map.of("home", name));
            return true;
        }
        this.plugin.sendMessage((CommandSender)p, "teleporting", Map.of("home", name, "seconds", String.valueOf(delay)));
        this.plugin.addTeleporting(p.getUniqueId());
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (!p.isOnline()) {
                this.plugin.removeTeleporting(p.getUniqueId());
                return;
            }
            if (!this.plugin.isTeleporting(p.getUniqueId())) {
                return;
            }
            this.plugin.removeTeleporting(p.getUniqueId());
            p.teleport(home.toLocation());
            this.plugin.sendMessage((CommandSender)p, "teleported", Map.of("home", name));
        }, (long)delay * 20L);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return List.of();
        }
        Player p = (Player)sender;
        if (args.length == 1) {
            return this.plugin.getHomeManager().getHomeNames(p.getUniqueId());
        }
        return List.of();
    }
}

