/*
 * Decompiled with CFR 0.152.
 */
package me.clipsezh.clipsezh;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.clipsezh.clipsezh.commands.DelHomeCommand;
import me.clipsezh.clipsezh.commands.HomeCommand;
import me.clipsezh.clipsezh.commands.HomesCommand;
import me.clipsezh.clipsezh.commands.SetHomeCommand;
import me.clipsezh.clipsezh.home.HomeManager;
import me.clipsezh.clipsezh.listeners.TeleportMoveListener;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ClipsEZHPlugin
extends JavaPlugin {
    private HomeManager homeManager;
    private final Set<UUID> teleporting = new HashSet<UUID>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.createDataFolder();
        this.homeManager = new HomeManager(this);
        this.registerCommands();
        this.getServer().getPluginManager().registerEvents((Listener)new TeleportMoveListener(this), (Plugin)this);
        this.getLogger().info("ClipsEZH enabled!");
    }

    private void createDataFolder() {
        File folder = new File(this.getDataFolder(), "data");
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    private void registerCommands() {
        HomeCommand homeCommand = new HomeCommand(this);
        DelHomeCommand delHomeCommand = new DelHomeCommand(this);
        this.getCommand("sethome").setExecutor((CommandExecutor)new SetHomeCommand(this));
        this.getCommand("home").setExecutor((CommandExecutor)homeCommand);
        this.getCommand("home").setTabCompleter((TabCompleter)homeCommand);
        this.getCommand("delhome").setExecutor((CommandExecutor)delHomeCommand);
        this.getCommand("delhome").setTabCompleter((TabCompleter)delHomeCommand);
        this.getCommand("homes").setExecutor((CommandExecutor)new HomesCommand(this));
    }

    public HomeManager getHomeManager() {
        return this.homeManager;
    }

    public int getTeleportDelay() {
        return this.getConfig().getInt("teleport-delay", 3);
    }

    public boolean isTeleportCancelOnMove() {
        return this.getConfig().getBoolean("teleport-cancel-on-move", true);
    }

    public void addTeleporting(UUID uuid) {
        this.teleporting.add(uuid);
    }

    public void removeTeleporting(UUID uuid) {
        this.teleporting.remove(uuid);
    }

    public boolean isTeleporting(UUID uuid) {
        return this.teleporting.contains(uuid);
    }

    public void sendMessage(CommandSender target, String key) {
        this.sendMessage(target, key, Collections.emptyMap());
    }

    public void sendMessage(CommandSender target, String key, Map<String, String> placeholders) {
        String msg = this.getConfig().getString("messages." + key, "");
        String prefix = this.getConfig().getString("messages.prefix", "");
        msg = msg.replace("%prefix%", prefix);
        HashMap<String, String> ph = new HashMap<String, String>(placeholders);
        ph.putIfAbsent("player", target.getName());
        for (Map.Entry entry : ph.entrySet()) {
            msg = msg.replace("%" + (String)entry.getKey() + "%", (CharSequence)entry.getValue());
        }
        target.sendRichMessage(msg);
    }
}

