/*
 * Decompiled with CFR 0.152.
 */
package com.clippyclip.clipsezeconomy.util;

import com.clippyclip.clipsezeconomy.ClipsEZEconomy;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;

public class MessageManager {
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");
    private final ClipsEZEconomy plugin;
    private String prefixRaw;
    private String prefixColored;

    public MessageManager(ClipsEZEconomy plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.prefixRaw = this.plugin.getConfig().getString("prefix", "&6[&eClipsBank&6]&r ");
        this.prefixColored = MessageManager.color(this.prefixRaw);
    }

    public String getPrefix() {
        return this.prefixColored;
    }

    public String getRaw(String path) {
        return this.plugin.getConfig().getString(path, "");
    }

    public String get(String path) {
        return this.get(path, null);
    }

    public String get(String path, Map<String, String> placeholders) {
        String msg = this.getRaw(path);
        if (msg == null || msg.isEmpty()) {
            return "";
        }
        msg = msg.replace("%prefix%", this.prefixColored);
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                msg = msg.replace("%" + entry.getKey() + "%", entry.getValue());
            }
        }
        return MessageManager.color(msg);
    }

    public List<String> getList(String path) {
        return this.getList(path, null);
    }

    public List<String> getList(String path, Map<String, String> placeholders) {
        List list = this.plugin.getConfig().getStringList(path);
        if (list == null || list.isEmpty()) {
            return list;
        }
        return list.stream().map(line -> {
            if (line == null) {
                return "";
            }
            line = line.replace("%prefix%", this.prefixColored);
            if (placeholders != null) {
                for (Map.Entry entry : placeholders.entrySet()) {
                    line = line.replace("%" + (String)entry.getKey() + "%", (CharSequence)entry.getValue());
                }
            }
            return MessageManager.color(line);
        }).collect(Collectors.toList());
    }

    public static String color(String input) {
        if (input == null) {
            return "";
        }
        Matcher matcher = HEX_PATTERN.matcher(input);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            StringBuilder replacement = new StringBuilder("\u00a7x");
            for (char c : hexColor.toCharArray()) {
                replacement.append('\u00a7').append(c);
            }
            matcher.appendReplacement(buffer, replacement.toString());
        }
        matcher.appendTail(buffer);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
    }
}

