/*
 * Decompiled with CFR 0.152.
 */
package com.clippyclip.clipsezeconomy.listeners;

import com.clippyclip.clipsezeconomy.ClipsEZEconomy;
import com.clippyclip.clipsezeconomy.economy.EconomyManager;
import com.clippyclip.clipsezeconomy.util.MessageManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ChatInputListener
implements Listener {
    private final ClipsEZEconomy plugin;
    private final EconomyManager economyManager;
    private final MessageManager mm;

    public ChatInputListener(ClipsEZEconomy plugin) {
        this.plugin = plugin;
        this.economyManager = plugin.getEconomyManager();
        this.mm = plugin.getMessageManager();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        ClipsEZEconomy.PendingBankInput pending = this.plugin.getPendingInput(uuid);
        if (pending == null) {
            return;
        }
        if (pending.isExpired()) {
            this.plugin.clearPendingAction(uuid);
            player.sendMessage(this.mm.get("messages.cancel-success"));
            return;
        }
        event.setCancelled(true);
        this.plugin.clearPendingAction(uuid);
        String message = event.getMessage().trim();
        if (message.equalsIgnoreCase("cancel")) {
            player.sendMessage(this.mm.get("messages.cancel-success"));
            return;
        }
        ClipsEZEconomy.BankAction action = pending.getAction();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (!player.isOnline()) {
                return;
            }
            if (message.equalsIgnoreCase("all")) {
                if (action == ClipsEZEconomy.BankAction.DEPOSIT) {
                    this.handleDepositAll(player);
                } else {
                    this.handleWithdrawAll(player);
                }
                return;
            }
            this.handleNumericAmount(player, action, message);
        });
    }

    private void handleDepositAll(Player player) {
        long emeralds = this.countEmeralds(player);
        if (emeralds <= 0L) {
            player.sendMessage(this.mm.get("messages.deposit-no-emeralds"));
            return;
        }
        if (!this.removeEmeralds(player, emeralds)) {
            player.sendMessage(this.mm.get("messages.inventory-remove-failed"));
            return;
        }
        this.economyManager.deposit(player.getUniqueId(), emeralds);
        player.sendMessage(this.mm.get("messages.deposit-success", Map.of("amount", String.valueOf(emeralds))));
        this.debug("Player " + player.getName() + " deposited " + emeralds + " emerald(s) (ALL).");
        this.reopenBank(player);
    }

    private void handleWithdrawAll(Player player) {
        long balance = this.economyManager.getBalance(player.getUniqueId());
        if (balance <= 0L) {
            player.sendMessage(this.mm.get("messages.withdraw-no-balance"));
            return;
        }
        this.handleWithdrawAmount(player, balance);
    }

    private void handleNumericAmount(Player player, ClipsEZEconomy.BankAction action, String message) {
        long amount;
        try {
            if (!message.matches("^[0-9]+$")) {
                throw new NumberFormatException("Not a plain integer");
            }
            amount = Long.parseLong(message);
        }
        catch (NumberFormatException ex) {
            player.sendMessage(this.mm.get("messages.invalid-amount"));
            return;
        }
        if (amount <= 0L) {
            player.sendMessage(this.mm.get("messages.amount-must-be-positive"));
            return;
        }
        if (action == ClipsEZEconomy.BankAction.DEPOSIT) {
            this.handleDepositAmount(player, amount);
        } else {
            this.handleWithdrawAmount(player, amount);
        }
    }

    private void handleDepositAmount(Player player, long amount) {
        long emeralds = this.countEmeralds(player);
        if (emeralds < amount) {
            player.sendMessage(this.mm.get("messages.deposit-not-enough-emeralds"));
            return;
        }
        if (!this.removeEmeralds(player, amount)) {
            player.sendMessage(this.mm.get("messages.inventory-remove-failed"));
            return;
        }
        this.economyManager.deposit(player.getUniqueId(), amount);
        player.sendMessage(this.mm.get("messages.deposit-success", Map.of("amount", String.valueOf(amount))));
        this.debug("Player " + player.getName() + " deposited " + amount + " emerald(s).");
        this.reopenBank(player);
    }

    private void handleWithdrawAmount(Player player, long amount) {
        if (amount <= 0L) {
            player.sendMessage(this.mm.get("messages.amount-must-be-positive"));
            return;
        }
        if (!this.economyManager.has(player.getUniqueId(), amount)) {
            player.sendMessage(this.mm.get("messages.withdraw-not-enough-balance"));
            return;
        }
        long capacity = this.countEmeraldCapacity(player);
        boolean dropIfFull = this.plugin.getConfig().getBoolean("bank.withdraw.drop-if-inventory-full", true);
        if (capacity < amount && !dropIfFull) {
            player.sendMessage(this.mm.get("messages.withdraw-inventory-full"));
            return;
        }
        if (!this.economyManager.withdraw(player.getUniqueId(), amount)) {
            player.sendMessage(this.mm.get("messages.withdraw-not-enough-balance"));
            return;
        }
        long dropped = this.giveEmeraldsWithOptionalDrop(player, amount, dropIfFull);
        player.sendMessage(this.mm.get("messages.withdraw-success", Map.of("amount", String.valueOf(amount))));
        if (dropped > 0L && this.plugin.getConfig().getBoolean("bank.withdraw.drop-message-enabled", true)) {
            player.sendMessage(this.mm.get("messages.withdraw-dropped", Map.of("amount", String.valueOf(dropped))));
        }
        this.debug("Player " + player.getName() + " withdrew " + amount + " emerald(s). Dropped=" + dropped);
        this.reopenBank(player);
    }

    private void reopenBank(Player player) {
        if (this.plugin.getConfig().getBoolean("gui.reopen-after-transaction", true)) {
            this.plugin.getBankMenu().openBank(player);
        }
    }

    private long countEmeralds(Player player) {
        long count = 0L;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != Material.EMERALD) continue;
            count += (long)item.getAmount();
        }
        return count;
    }

    private long countEmeraldCapacity(Player player) {
        long capacity = 0L;
        for (ItemStack item : player.getInventory().getStorageContents()) {
            if (item == null || item.getType() == Material.AIR) {
                capacity += (long)Material.EMERALD.getMaxStackSize();
                continue;
            }
            if (item.getType() != Material.EMERALD) continue;
            capacity += (long)(Material.EMERALD.getMaxStackSize() - item.getAmount());
        }
        return capacity;
    }

    private boolean removeEmeralds(Player player, long amount) {
        long remaining = amount;
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length && remaining > 0L; ++i) {
            ItemStack item = contents[i];
            if (item == null || item.getType() != Material.EMERALD) continue;
            int stackAmount = item.getAmount();
            if ((long)stackAmount <= remaining) {
                remaining -= (long)stackAmount;
                contents[i] = null;
                continue;
            }
            item.setAmount(stackAmount - (int)remaining);
            remaining = 0L;
        }
        player.getInventory().setContents(contents);
        player.updateInventory();
        return remaining == 0L;
    }

    private long giveEmeraldsWithOptionalDrop(Player player, long amount, boolean dropIfFull) {
        int toGive;
        long dropped = 0L;
        for (long remaining = amount; remaining > 0L; remaining -= (long)toGive) {
            toGive = (int)Math.min(remaining, (long)Material.EMERALD.getMaxStackSize());
            ItemStack stack = new ItemStack(Material.EMERALD, toGive);
            HashMap leftovers = player.getInventory().addItem(new ItemStack[]{stack});
            if (leftovers.isEmpty()) continue;
            for (ItemStack left : leftovers.values()) {
                if (left == null) continue;
                int leftAmount = left.getAmount();
                if (dropIfFull) {
                    player.getWorld().dropItemNaturally(player.getLocation(), left);
                    dropped += (long)leftAmount;
                    continue;
                }
                dropped += (long)leftAmount;
            }
        }
        player.updateInventory();
        return dropped;
    }

    private void debug(String message) {
        if (this.plugin.getConfig().getBoolean("debug.enabled", false)) {
            this.plugin.getLogger().info("[DEBUG] " + message);
        }
    }
}

