/*
 * Decompiled with CFR 0.152.
 */
package com.clippyclip.clipsezeconomy.listeners;

import com.clippyclip.clipsezeconomy.ClipsEZEconomy;
import com.clippyclip.clipsezeconomy.gui.BankMenuHolder;
import com.clippyclip.clipsezeconomy.util.MessageManager;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;

public class BankMenuListener
implements Listener {
    private final ClipsEZEconomy plugin;
    private final MessageManager mm;

    public BankMenuListener(ClipsEZEconomy plugin) {
        this.plugin = plugin;
        this.mm = plugin.getMessageManager();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity clicker = event.getWhoClicked();
        if (!(clicker instanceof Player)) {
            return;
        }
        if (!(event.getView().getTopInventory().getHolder() instanceof BankMenuHolder)) {
            return;
        }
        event.setCancelled(true);
        if (event.getRawSlot() < 0 || event.getRawSlot() >= event.getView().getTopInventory().getSize()) {
            return;
        }
        Player player = (Player)clicker;
        int slot = event.getRawSlot();
        switch (slot) {
            case 11: {
                this.plugin.setPendingAction(player.getUniqueId(), ClipsEZEconomy.BankAction.DEPOSIT);
                player.closeInventory();
                player.sendMessage(this.mm.get("messages.chat-deposit-prompt-line1"));
                player.sendMessage(this.mm.get("messages.chat-deposit-prompt-line2"));
                break;
            }
            case 15: {
                this.plugin.setPendingAction(player.getUniqueId(), ClipsEZEconomy.BankAction.WITHDRAW);
                player.closeInventory();
                player.sendMessage(this.mm.get("messages.chat-withdraw-prompt-line1"));
                player.sendMessage(this.mm.get("messages.chat-withdraw-prompt-line2"));
                break;
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (!(event.getView().getTopInventory().getHolder() instanceof BankMenuHolder)) {
            return;
        }
        int topSize = event.getView().getTopInventory().getSize();
        boolean affectsTop = event.getRawSlots().stream().anyMatch(slot -> slot < topSize);
        if (affectsTop) {
            event.setCancelled(true);
        }
    }
}

