/*
 * Decompiled with CFR 0.152.
 */
package com.clippyclip.clipsezeconomy.gui;

import com.clippyclip.clipsezeconomy.ClipsEZEconomy;
import com.clippyclip.clipsezeconomy.economy.EconomyManager;
import com.clippyclip.clipsezeconomy.gui.BankMenuHolder;
import com.clippyclip.clipsezeconomy.util.MessageManager;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BankMenu {
    private final ClipsEZEconomy plugin;
    private final EconomyManager economyManager;
    private final MessageManager mm;

    public BankMenu(ClipsEZEconomy plugin) {
        this.plugin = plugin;
        this.economyManager = plugin.getEconomyManager();
        this.mm = plugin.getMessageManager();
    }

    public void openBank(Player player) {
        long balance = this.economyManager.getBalance(player.getUniqueId());
        String title = this.mm.get("gui.bank-title");
        Inventory inv = Bukkit.createInventory((InventoryHolder)new BankMenuHolder(), (int)27, (String)title);
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.setDisplayName(" ");
        filler.setItemMeta(fillerMeta);
        for (int i = 0; i < inv.getSize(); ++i) {
            inv.setItem(i, filler);
        }
        ItemStack deposit = new ItemStack(Material.EMERALD_BLOCK);
        ItemMeta depMeta = deposit.getItemMeta();
        depMeta.setDisplayName(this.mm.get("gui.bank-deposit-button-name"));
        depMeta.setLore(this.mm.getList("gui.bank-deposit-button-lore"));
        depMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        deposit.setItemMeta(depMeta);
        ItemStack withdraw = new ItemStack(Material.EMERALD);
        ItemMeta wdMeta = withdraw.getItemMeta();
        wdMeta.setDisplayName(this.mm.get("gui.bank-withdraw-button-name"));
        wdMeta.setLore(this.mm.getList("gui.bank-withdraw-button-lore"));
        wdMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        withdraw.setItemMeta(wdMeta);
        ItemStack balanceItem = new ItemStack(Material.PAPER);
        ItemMeta balMeta = balanceItem.getItemMeta();
        balMeta.setDisplayName(this.mm.get("gui.bank-balance-item-name"));
        List<String> lore = this.mm.getList("gui.bank-balance-item-lore", Map.of("amount", String.valueOf(balance)));
        balMeta.setLore(lore);
        balanceItem.setItemMeta(balMeta);
        inv.setItem(11, deposit);
        inv.setItem(13, balanceItem);
        inv.setItem(15, withdraw);
        player.openInventory(inv);
    }
}

