/*
 * Decompiled with CFR 0.152.
 */
package com.clippyclip.clipsezeconomy.economy;

import com.clippyclip.clipsezeconomy.ClipsEZEconomy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class EconomyManager {
    private final ClipsEZEconomy plugin;
    private final Map<UUID, Long> balances;

    public EconomyManager(ClipsEZEconomy plugin, Map<UUID, Long> initialBalances) {
        this.plugin = plugin;
        this.balances = new HashMap<UUID, Long>(initialBalances);
    }

    public Map<UUID, Long> getBalancesSnapshot() {
        return Collections.unmodifiableMap(new HashMap<UUID, Long>(this.balances));
    }

    public long getBalance(UUID uuid) {
        return this.balances.getOrDefault(uuid, 0L);
    }

    public void setBalance(UUID uuid, long amount) {
        if (amount < 0L) {
            amount = 0L;
        }
        this.balances.put(uuid, amount);
        this.plugin.getDataManager().markDirty();
    }

    public void deposit(UUID uuid, long amount) {
        if (amount <= 0L) {
            return;
        }
        long current = this.getBalance(uuid);
        long newBalance = current + amount;
        if (newBalance < 0L) {
            newBalance = Long.MAX_VALUE;
        }
        this.balances.put(uuid, newBalance);
        this.plugin.getDataManager().markDirty();
    }

    public boolean withdraw(UUID uuid, long amount) {
        if (amount <= 0L) {
            return false;
        }
        long current = this.getBalance(uuid);
        if (current < amount) {
            return false;
        }
        long newBalance = current - amount;
        if (newBalance < 0L) {
            newBalance = 0L;
        }
        this.balances.put(uuid, newBalance);
        this.plugin.getDataManager().markDirty();
        return true;
    }

    public boolean has(UUID uuid, long amount) {
        return amount > 0L && this.getBalance(uuid) >= amount;
    }

    public void replaceAll(Map<UUID, Long> newBalances) {
        this.balances.clear();
        this.balances.putAll(newBalances);
        this.plugin.getDataManager().markDirty();
    }
}

