/*
 * Decompiled with CFR 0.152.
 */
package com.clippyclip.clipsezeconomy.data;

import com.clippyclip.clipsezeconomy.ClipsEZEconomy;
import com.clippyclip.clipsezeconomy.economy.EconomyManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataManager {
    private final ClipsEZEconomy plugin;
    private final File balancesFile;
    private FileConfiguration balancesConfig;
    private final AtomicBoolean dirty = new AtomicBoolean(false);

    public DataManager(ClipsEZEconomy plugin) {
        this.plugin = plugin;
        this.balancesFile = new File(plugin.getDataFolder(), "balances.yml");
        this.reload();
    }

    private void reload() {
        if (!this.balancesFile.exists()) {
            try {
                this.balancesFile.getParentFile().mkdirs();
                this.balancesFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create balances.yml!");
                e.printStackTrace();
            }
        }
        this.balancesConfig = YamlConfiguration.loadConfiguration((File)this.balancesFile);
    }

    public void markDirty() {
        this.dirty.set(true);
    }

    public boolean isDirty() {
        return this.dirty.get();
    }

    public Map<UUID, Long> loadBalances() {
        this.reload();
        HashMap<UUID, Long> map = new HashMap<UUID, Long>();
        if (!this.balancesConfig.isConfigurationSection("balances")) {
            return map;
        }
        for (String key : this.balancesConfig.getConfigurationSection("balances").getKeys(false)) {
            try {
                UUID uuid = UUID.fromString(key);
                long balance = this.balancesConfig.getLong("balances." + key + ".balance", 0L);
                map.put(uuid, Math.max(balance, 0L));
            }
            catch (IllegalArgumentException ex) {
                this.plugin.getLogger().warning("Invalid UUID in balances.yml: " + key);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flushSaveNow(Map<UUID, Long> balances) {
        if (this.balancesConfig == null) {
            this.reload();
        }
        this.balancesConfig.set("balances", null);
        for (Map.Entry<UUID, Long> entry : balances.entrySet()) {
            String path = "balances." + String.valueOf(entry.getKey());
            this.balancesConfig.set(path + ".balance", (Object)Math.max(entry.getValue(), 0L));
        }
        File temp = new File(this.plugin.getDataFolder(), "balances.yml.tmp");
        try {
            this.balancesConfig.save(temp);
            Files.move(temp.toPath(), this.balancesFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            this.dirty.set(false);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save balances.yml!");
            e.printStackTrace();
        }
        finally {
            if (temp.exists()) {
                temp.delete();
            }
        }
    }

    public void reloadBalancesInto(EconomyManager economyManager) {
        Map<UUID, Long> loaded = this.loadBalances();
        economyManager.replaceAll(loaded);
        this.dirty.set(false);
    }
}

