/*
 * Decompiled with CFR 0.152.
 */
package com.clippyclip.clipsezeconomy.commands;

import com.clippyclip.clipsezeconomy.ClipsEZEconomy;
import com.clippyclip.clipsezeconomy.api.ClipsEZEconomyAPI;
import com.clippyclip.clipsezeconomy.util.MessageManager;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class EcoCommand
implements CommandExecutor {
    private final ClipsEZEconomy plugin;
    private final MessageManager mm;

    public EcoCommand(ClipsEZEconomy plugin) {
        this.plugin = plugin;
        this.mm = plugin.getMessageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        long amount;
        if (!sender.hasPermission("clipsezeconomy.admin")) {
            sender.sendMessage(this.mm.get("messages.no-permission"));
            return true;
        }
        if (args.length != 3) {
            sender.sendMessage(this.mm.get("messages.eco-usage", Map.of("label", label)));
            return true;
        }
        String action = args[0].toLowerCase();
        String targetName = args[1];
        String amountStr = args[2];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (target == null || target.getName() == null) {
            sender.sendMessage(this.mm.get("messages.eco-player-not-found"));
            return true;
        }
        try {
            amount = Long.parseLong(amountStr);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.mm.get("messages.eco-invalid-amount"));
            return true;
        }
        if (amount < 0L) {
            sender.sendMessage(this.mm.get("messages.eco-invalid-amount"));
            return true;
        }
        long current = ClipsEZEconomyAPI.getBalance(target.getUniqueId());
        switch (action) {
            case "set": {
                ClipsEZEconomyAPI.setBalance(target.getUniqueId(), amount);
                sender.sendMessage(this.mm.get("messages.eco-set-success", Map.of("player", target.getName(), "amount", String.valueOf(amount))));
                break;
            }
            case "add": {
                long newBalance = current + amount;
                ClipsEZEconomyAPI.setBalance(target.getUniqueId(), newBalance);
                sender.sendMessage(this.mm.get("messages.eco-add-success", Map.of("player", target.getName(), "amount", String.valueOf(amount), "newbalance", String.valueOf(newBalance))));
                break;
            }
            case "take": {
                if (current < amount) {
                    sender.sendMessage(this.mm.get("messages.eco-take-too-much", Map.of("player", target.getName(), "amount", String.valueOf(current))));
                    return true;
                }
                long newBalance = current - amount;
                ClipsEZEconomyAPI.setBalance(target.getUniqueId(), newBalance);
                sender.sendMessage(this.mm.get("messages.eco-take-success", Map.of("player", target.getName(), "amount", String.valueOf(amount), "newbalance", String.valueOf(newBalance))));
                break;
            }
            default: {
                sender.sendMessage(this.mm.get("messages.eco-usage", Map.of("label", label)));
            }
        }
        return true;
    }
}

