/*
 * Decompiled with CFR 0.152.
 */
package com.clippyclip.clipsezeconomy.commands;

import com.clippyclip.clipsezeconomy.ClipsEZEconomy;
import com.clippyclip.clipsezeconomy.economy.EconomyManager;
import com.clippyclip.clipsezeconomy.util.MessageManager;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class BaltopCommand
implements CommandExecutor {
    private final ClipsEZEconomy plugin;
    private final EconomyManager economyManager;
    private final MessageManager mm;

    public BaltopCommand(ClipsEZEconomy plugin) {
        this.plugin = plugin;
        this.economyManager = plugin.getEconomyManager();
        this.mm = plugin.getMessageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("clipsezeconomy.baltop")) {
            sender.sendMessage(this.mm.get("messages.no-permission"));
            return true;
        }
        Map<UUID, Long> balances = this.economyManager.getBalancesSnapshot();
        if (balances.isEmpty()) {
            sender.sendMessage(this.mm.get("messages.baltop-no-data"));
            return true;
        }
        List top = balances.entrySet().stream().sorted((a, b) -> Long.compare((Long)b.getValue(), (Long)a.getValue())).limit(5L).collect(Collectors.toList());
        sender.sendMessage(this.mm.get("messages.baltop-header"));
        int rank = 1;
        for (Map.Entry entry : top) {
            UUID uuid = (UUID)entry.getKey();
            long amount = (Long)entry.getValue();
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
            String name = player != null && player.getName() != null ? player.getName() : "Unknown";
            sender.sendMessage(this.mm.get("messages.baltop-entry", Map.of("rank", String.valueOf(rank), "player", name, "amount", String.valueOf(amount))));
            ++rank;
        }
        return true;
    }
}

