/*
 * Decompiled with CFR 0.152.
 */
package com.clippyclip.clipsezeconomy.commands;

import com.clippyclip.clipsezeconomy.ClipsEZEconomy;
import com.clippyclip.clipsezeconomy.economy.EconomyManager;
import com.clippyclip.clipsezeconomy.util.MessageManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class BalanceCommand
implements CommandExecutor,
TabCompleter {
    private final ClipsEZEconomy plugin;
    private final EconomyManager economyManager;

    public BalanceCommand(ClipsEZEconomy plugin) {
        this.plugin = plugin;
        this.economyManager = plugin.getEconomyManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        MessageManager mm = this.plugin.getMessageManager();
        if (!sender.hasPermission("clipsezeconomy.balance")) {
            sender.sendMessage(mm.get("messages.no-permission"));
            return true;
        }
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(mm.get("messages.balance-console-usage"));
                return true;
            }
            Player player = (Player)sender;
            long balance = this.economyManager.getBalance(player.getUniqueId());
            sender.sendMessage(mm.get("messages.balance-self", Map.of("amount", String.valueOf(balance))));
            return true;
        }
        String targetName = args[0];
        OfflinePlayer target = Bukkit.getOfflinePlayerIfCached((String)targetName);
        if (target == null) {
            target = Bukkit.getOfflinePlayer((String)targetName);
        }
        if (target == null || target.getUniqueId() == null) {
            sender.sendMessage(mm.get("messages.player-not-found", Map.of("player", targetName)));
            return true;
        }
        long balance = this.economyManager.getBalance(target.getUniqueId());
        String displayName = target.getName() != null ? target.getName() : targetName;
        sender.sendMessage(mm.get("messages.balance-other", Map.of("player", displayName, "amount", String.valueOf(balance))));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String prefix = args[0].toLowerCase();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getName().toLowerCase().startsWith(prefix)) continue;
                completions.add(p.getName());
            }
        }
        return completions;
    }
}

