/*
 * Decompiled with CFR 0.152.
 */
package com.clippyclip.clipsezeconomy;

import com.clippyclip.clipsezeconomy.api.BukkitEconomyProvider;
import com.clippyclip.clipsezeconomy.api.ClipsEZEconomyAPI;
import com.clippyclip.clipsezeconomy.api.EconomyProvider;
import com.clippyclip.clipsezeconomy.commands.BalanceCommand;
import com.clippyclip.clipsezeconomy.commands.BaltopCommand;
import com.clippyclip.clipsezeconomy.commands.BankCommand;
import com.clippyclip.clipsezeconomy.commands.EcoCommand;
import com.clippyclip.clipsezeconomy.commands.MainCommand;
import com.clippyclip.clipsezeconomy.data.DataManager;
import com.clippyclip.clipsezeconomy.economy.EconomyManager;
import com.clippyclip.clipsezeconomy.gui.BankMenu;
import com.clippyclip.clipsezeconomy.listeners.BankMenuListener;
import com.clippyclip.clipsezeconomy.listeners.ChatInputListener;
import com.clippyclip.clipsezeconomy.listeners.PlayerCleanupListener;
import com.clippyclip.clipsezeconomy.util.MessageManager;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class ClipsEZEconomy
extends JavaPlugin {
    private static ClipsEZEconomy instance;
    private DataManager dataManager;
    private EconomyManager economyManager;
    private BankMenu bankMenu;
    private MessageManager messageManager;
    private final Map<UUID, PendingBankInput> pendingInputs = new ConcurrentHashMap<UUID, PendingBankInput>();

    public void onEnable() {
        instance = this;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.saveDefaultConfig();
        this.getConfig().addDefault("data.autosave-interval-seconds", (Object)300);
        this.getConfig().addDefault("bank.chat-input-timeout-seconds", (Object)15);
        this.getConfig().addDefault("bank.withdraw.drop-if-inventory-full", (Object)true);
        this.getConfig().addDefault("bank.withdraw.drop-message-enabled", (Object)true);
        this.getConfig().addDefault("messages.withdraw-inventory-full", (Object)"%prefix%&cYour inventory is full. Clear space before withdrawing.");
        this.getConfig().addDefault("messages.withdraw-dropped", (Object)"%prefix%&e%amount% &7emerald(s) were dropped on the ground because your inventory was full.");
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.dataManager = new DataManager(this);
        this.economyManager = new EconomyManager(this, this.dataManager.loadBalances());
        this.messageManager = new MessageManager(this);
        this.bankMenu = new BankMenu(this);
        this.getServer().getServicesManager().register(EconomyProvider.class, (Object)new BukkitEconomyProvider(this.economyManager), (Plugin)this, ServicePriority.Normal);
        ClipsEZEconomyAPI.initialize(this);
        this.registerCommands();
        this.registerListeners();
        this.startAutosaveTask();
        this.startPendingInputCleanupTask();
        this.getLogger().info("ClipsEZEconomy enabled.");
    }

    public void onDisable() {
        this.dataManager.flushSaveNow(this.economyManager.getBalancesSnapshot());
        this.pendingInputs.clear();
        this.getLogger().info("ClipsEZEconomy disabled. Balances saved.");
    }

    private void registerCommands() {
        if (this.getCommand("bank") != null) {
            this.getCommand("bank").setExecutor((CommandExecutor)new BankCommand(this));
        }
        if (this.getCommand("balance") != null) {
            BalanceCommand balanceCommand = new BalanceCommand(this);
            this.getCommand("balance").setExecutor((CommandExecutor)balanceCommand);
            this.getCommand("balance").setTabCompleter((TabCompleter)balanceCommand);
        }
        if (this.getCommand("clipsezeconomy") != null) {
            this.getCommand("clipsezeconomy").setExecutor((CommandExecutor)new MainCommand(this));
        }
        if (this.getCommand("baltop") != null) {
            this.getCommand("baltop").setExecutor((CommandExecutor)new BaltopCommand(this));
        }
        if (this.getCommand("eco") != null) {
            this.getCommand("eco").setExecutor((CommandExecutor)new EcoCommand(this));
        }
    }

    private void registerListeners() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new BankMenuListener(this), (Plugin)this);
        pm.registerEvents((Listener)new ChatInputListener(this), (Plugin)this);
        pm.registerEvents((Listener)new PlayerCleanupListener(this), (Plugin)this);
    }

    private void startAutosaveTask() {
        int seconds = Math.max(30, this.getConfig().getInt("data.autosave-interval-seconds", 300));
        long ticks = (long)seconds * 20L;
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            if (this.dataManager.isDirty()) {
                this.dataManager.flushSaveNow(this.economyManager.getBalancesSnapshot());
            }
        }, ticks, ticks);
    }

    private void startPendingInputCleanupTask() {
        long period = 600L;
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> this.pendingInputs.entrySet().removeIf(e -> e.getValue() == null || ((PendingBankInput)e.getValue()).isExpired()), period, period);
    }

    public static ClipsEZEconomy getInstance() {
        return instance;
    }

    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public BankMenu getBankMenu() {
        return this.bankMenu;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public void setPendingAction(UUID uuid, BankAction action) {
        long timeoutSeconds = Math.max(5L, this.getConfig().getLong("bank.chat-input-timeout-seconds", 15L));
        long expiresAt = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timeoutSeconds);
        this.pendingInputs.put(uuid, new PendingBankInput(action, expiresAt));
    }

    public PendingBankInput getPendingInput(UUID uuid) {
        return this.pendingInputs.get(uuid);
    }

    public void clearPendingAction(UUID uuid) {
        this.pendingInputs.remove(uuid);
    }

    public void clearAllPendingInputsFor(UUID uuid) {
        this.pendingInputs.remove(uuid);
    }

    public static final class PendingBankInput {
        private final BankAction action;
        private final long expiresAtMillis;

        public PendingBankInput(BankAction action, long expiresAtMillis) {
            this.action = action;
            this.expiresAtMillis = expiresAtMillis;
        }

        public BankAction getAction() {
            return this.action;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.expiresAtMillis;
        }
    }

    public static enum BankAction {
        DEPOSIT,
        WITHDRAW;

    }
}

