/*
 * Decompiled with CFR 0.152.
 */
package com.github.cinnamondev.minemoji;

import com.github.cinnamondev.minemoji.EmojiSet;
import com.github.cinnamondev.minemoji.Minemoji;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fellbaum.jemoji.Emoji;
import net.fellbaum.jemoji.EmojiManager;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.ObjectComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.object.ObjectContents;
import net.kyori.adventure.text.object.SpriteObjectContents;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.StringUtils;

public class SpriteEmojiManager {
    private final Minemoji p;
    private boolean IS_BASE_EMOJIS_AVAILABLE = false;
    private final Map<Emoji, ObjectComponent> emojiMap;
    Map<String, EmojiSet> customPacks;
    BidiMap<String, Key> customSprites;
    private final TextReplacementConfig UNICODE_REPLACER = (TextReplacementConfig)TextReplacementConfig.builder().match(EmojiManager.getEmojiPattern()).replacement((result, b) -> {
        String match = result.group();
        return (ComponentLike)EmojiManager.getEmoji(match).flatMap(emoji -> this.getEmojiFromActual((Emoji)emoji).map(c -> c)).orElse(Component.text((String)match));
    }).build();
    private final TextReplacementConfig PREFIXED_EMOTE_REPLACER = (TextReplacementConfig)TextReplacementConfig.builder().match(Pattern.compile(":(([a-zA-Z0-9_]*)--([a-zA-Z0-9_~]*)):")).replacement((result, b) -> {
        if (result.group(2).trim().equalsIgnoreCase("unicode")) {
            return (ComponentLike)EmojiManager.getByDiscordAlias(":" + result.group(3) + ":").flatMap(emoji -> this.getEmojiFromActual((Emoji)emoji).map(c -> c)).orElse(Component.text((String)result.group()));
        }
        return (ComponentLike)this.getNamespacedCustomEmoji(result.group(1).trim().toLowerCase()).map(c -> c).orElse((Component)Component.text((String)result.group()));
    }).build();
    private final TextReplacementConfig DEFAULT_EMOTE_REPLACER = (TextReplacementConfig)TextReplacementConfig.builder().match(":([a-zA-Z0-9_~]*):").replacement((result, b) -> {
        String match = result.group(1).toLowerCase().trim();
        return (ComponentLike)this.getCustomEmoji(match).map(c -> c).orElse(EmojiManager.getByDiscordAlias(result.group()).flatMap(this::getEmojiFromActual).map(c -> c).orElse((Component)Component.text((String)result.group())));
    }).build();

    public boolean baseEmojisAvailable() {
        return this.IS_BASE_EMOJIS_AVAILABLE;
    }

    public static CompletableFuture<SpriteEmojiManager> fromRemotePacks(Minemoji p, List<URI> packs) {
        p.getLogger().info("Creating emoji manager using remote packs");
        Gson gson = new Gson();
        try (HttpClient client = HttpClient.newHttpClient();){
            List<CompletableFuture> futures = packs.stream().map(pack -> HttpRequest.newBuilder(pack).GET().build()).map(request -> ((CompletableFuture)((CompletableFuture)client.sendAsync((HttpRequest)request, HttpResponse.BodyHandlers.ofInputStream()).thenApply(HttpResponse::body)).thenApply(InputStreamReader::new)).thenApply(stream -> gson.fromJson((Reader)stream, EmojiSet.class))).toList();
            CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(_v -> futures.stream().map(CompletableFuture::join))).exceptionally(ex -> futures.stream().flatMap(f -> {
                try {
                    return Stream.of((EmojiSet)f.join());
                }
                catch (CompletionException e) {
                    p.getLogger().warning("Malformed pack, ignoring... See message");
                    p.getLogger().warning(ex.getMessage());
                    return Stream.empty();
                }
            }))).thenApply(s -> s.map(set -> Map.entry(set.prefix, set)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))).thenApply(map -> new SpriteEmojiManager(p, (Map<String, EmojiSet>)map));
            return completionStage;
        }
    }

    public static SpriteEmojiManager fromLocalPacks(Minemoji p, File packsDirectory) {
        p.getLogger().info("Creating emoji manager using local packs");
        return new SpriteEmojiManager(p, SpriteEmojiManager.discoverEmojiPacks(p, packsDirectory));
    }

    private static Map<String, EmojiSet> discoverEmojiPacks(Minemoji p, File packsDirectory) {
        HashMap<String, EmojiSet> map = new HashMap<String, EmojiSet>();
        Gson gson = new Gson();
        if (!packsDirectory.exists()) {
            packsDirectory.mkdirs();
            p.getLogger().info("Creating packs directory (no packs available): " + packsDirectory.getAbsolutePath());
            return Collections.emptyMap();
        }
        File[] files = packsDirectory.listFiles((dir, name) -> name.endsWith(".json"));
        if (files == null || files.length == 0) {
            p.getLogger().info("no files in packs directory matching filter(?)");
            return Collections.emptyMap();
        }
        for (File pack : files) {
            try {
                FileReader reader = new FileReader(pack);
                EmojiSet set = gson.fromJson((Reader)reader, EmojiSet.class);
                for (EmojiSet.SpriteMeta emoji : set.emojis) {
                    emoji.emojiText = emoji.emojiText.toLowerCase().strip();
                }
                map.put(set.prefix, set);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    protected SpriteEmojiManager(Minemoji p, Map<String, EmojiSet> customPacks) {
        this.p = p;
        p.getLogger().info("Found following packs:" + String.join((CharSequence)", ", customPacks.keySet()));
        if (p.getConfig().getBoolean("unicode-emojis.enabled", true)) {
            this.emojiMap = this.createBaseEmojiSet();
            if (!this.emojiMap.isEmpty()) {
                this.IS_BASE_EMOJIS_AVAILABLE = true;
            }
        } else {
            this.emojiMap = Collections.emptyMap();
        }
        this.customPacks = customPacks;
        this.customSprites = new DualHashBidiMap<String, Key>(customPacks.entrySet().stream().flatMap(e -> ((EmojiSet)e.getValue()).emojis.stream().map(meta -> Map.entry(meta.emojiText, Key.key((String)meta.resource)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public static ObjectComponent spriteMetaToComponent(EmojiSet.SpriteMeta meta) {
        return Component.object((ObjectContents)ObjectContents.sprite((Key)Key.key((String)"paintings"), (Key)Key.key((String)meta.resource)));
    }

    public Map<Emoji, ObjectComponent> getDefaultEmojiMap() {
        return Collections.unmodifiableMap(this.emojiMap);
    }

    public Map<String, EmojiSet> getCustomPacks() {
        return Collections.unmodifiableMap(this.customPacks);
    }

    public Optional<ObjectComponent> getEmojiFromActual(Emoji emoji) {
        return Optional.ofNullable(this.emojiMap.get(emoji));
    }

    public Optional<String> getCustomEmojiBySprite(Key sprite) {
        return Optional.ofNullable(this.customSprites.getKey(sprite));
    }

    public Optional<ObjectComponent> getCustomEmoji(String key) {
        return Optional.ofNullable((Key)this.customSprites.get(key)).map(sprite -> Component.object((ObjectContents)ObjectContents.sprite((Key)Key.key((String)"paintings"), (Key)sprite)));
    }

    public Map<Emoji, ObjectComponent> createBaseEmojiSet() {
        return EmojiManager.getAllEmojis().stream().map(e -> Map.entry(e, Component.object((ObjectContents)ObjectContents.sprite((Key)Key.key((String)"paintings"), (Key)Key.key((String)("unicode/" + StringUtils.joinWith((String)"-", (Object[])e.getHtmlHexadecimalCode().replace("&#x", "").split(";")).toLowerCase())))))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected Optional<Emoji> getEmojiBySprite(Key sprite) {
        String[] arr = sprite.value().split("/");
        String trimmedHexCode = arr[arr.length - 1];
        String hexCode = Arrays.stream(trimmedHexCode.split("-")).map(str -> "&#x" + str).collect(Collectors.joining(";")) + ";";
        return EmojiManager.getByHtmlHexadecimal(hexCode);
    }

    protected Component demojizeSingleComponent(Component component) {
        ObjectComponent o;
        ObjectContents objectContents;
        if (component instanceof ObjectComponent && (objectContents = (o = (ObjectComponent)component).contents()) instanceof SpriteObjectContents) {
            SpriteObjectContents s = (SpriteObjectContents)objectContents;
            return this.getCustomEmojiBySprite(s.sprite()).map(str -> Component.text((String)(":" + str + ":"))).orElse(this.getEmojiBySprite(s.sprite()).map(e -> e.getDiscordAliases().getFirst()).map(str -> Component.text((String)str)).orElse(component));
        }
        return component;
    }

    public Component demojize(Component component) {
        List childs = component.children().stream().map(this::demojizeSingleComponent).collect(Collectors.toList());
        return this.demojizeSingleComponent(component).children(childs);
    }

    public Component emojize(Component component) {
        return component.replaceText(this.UNICODE_REPLACER).replaceText(this.PREFIXED_EMOTE_REPLACER).replaceText(this.DEFAULT_EMOTE_REPLACER);
    }

    protected Optional<EmojiSet> getPackByPrefix(String prefix) {
        return Optional.ofNullable(this.customPacks.get(prefix));
    }

    public Optional<ObjectComponent> getNamespacedCustomEmoji(String identifier) {
        String[] _arr = identifier.split("--", 2);
        String packIdentifier = _arr[0];
        String spriteName = _arr[1];
        return this.getPackByPrefix(packIdentifier).flatMap(set -> set.emojis.stream().filter(emote -> emote.emojiText.equalsIgnoreCase(spriteName)).findFirst().map(SpriteEmojiManager::spriteMetaToComponent));
    }
}

