/*
 * Decompiled with CFR 0.152.
 */
package com.github.cinnamondev.minemoji;

import com.destroystokyo.paper.event.player.PlayerConnectionCloseEvent;
import com.github.cinnamondev.minemoji.Minemoji;
import com.github.cinnamondev.minemoji.SpriteEmojiManager;
import io.papermc.paper.event.connection.configuration.AsyncPlayerConnectionConfigureEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.resource.ResourcePackInfo;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class RequestPacks
implements Listener {
    private final Minemoji p;
    private final List<ResourcePackInfo> packs;
    private final Component joinPrompt;
    private final HashMap<UUID, CountDownLatch> waitingConfigurationThreads = new HashMap();

    public static CompletableFuture<RequestPacks> requestPacks(Minemoji p, SpriteEmojiManager emojiManager) throws URISyntaxException {
        ArrayList futures = emojiManager.customPacks.values().parallelStream().filter(pack -> pack.serveToClient).map(e -> ResourcePackInfo.resourcePackInfo().uri(e.url).id(UUID.nameUUIDFromBytes(e.prefix.getBytes())).computeHashAndBuild()).collect(Collectors.toCollection(ArrayList::new));
        if (p.getConfig().getBoolean("unicode-emojis.enabled", true)) {
            String defaultPack = p.getConfig().getString("unicode-emojis.uri");
            URI uri = defaultPack == null ? Minemoji.DEFAULT_URI : new URI(defaultPack);
            futures.add(ResourcePackInfo.resourcePackInfo().uri(uri).id(UUID.nameUUIDFromBytes("unicode-emojis".getBytes())).computeHashAndBuild());
        }
        if (futures.isEmpty()) {
            p.getComponentLogger().warn("No resource packs to serve.");
            return CompletableFuture.completedFuture(new RequestPacks(p, Collections.emptyList()));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(_v -> new RequestPacks(p, futures.stream().map(CompletableFuture::join).toList()));
    }

    protected RequestPacks(Minemoji p, List<ResourcePackInfo> packs) {
        this.p = p;
        this.packs = packs;
        String miniMessage = p.getConfig().getString("join-prompt");
        if (miniMessage != null && !miniMessage.isEmpty()) {
            MiniMessage mm = MiniMessage.miniMessage();
            this.joinPrompt = mm.deserialize((Object)miniMessage);
        } else {
            this.joinPrompt = null;
        }
    }

    @EventHandler
    public void serveEmojiPacks(AsyncPlayerConnectionConfigureEvent e) throws InterruptedException {
        UUID uuid = e.getConnection().getProfile().getId();
        CountDownLatch latch = this.waitingConfigurationThreads.computeIfAbsent(uuid, _u -> new CountDownLatch(this.packs.size()));
        AtomicBoolean accepted = new AtomicBoolean(true);
        ResourcePackRequest request = (ResourcePackRequest)ResourcePackRequest.resourcePackRequest().packs(this.packs).replace(false).required(this.p.getConfig().getBoolean("enforce-packs", false)).prompt(this.joinPrompt).callback(ResourcePackCallback.onTerminal((packUuid, audience) -> this.waitingConfigurationThreads.computeIfPresent(uuid, (_uuid, l) -> {
            l.countDown();
            return l;
        }), (packUuid, audience) -> {
            this.waitingConfigurationThreads.computeIfPresent(uuid, (_uuid, l) -> {
                l.countDown();
                return l;
            });
            accepted.set(false);
            audience.sendMessage((Component)Component.text((String)"We use resource packs to serve emojis! :("));
        })).build();
        e.getConnection().getAudience().sendResourcePacks(request);
        latch.await(30L, TimeUnit.SECONDS);
        if (!accepted.get() && this.p.getConfig().getBoolean("enforce-packs", false)) {
            e.getConnection().disconnect((Component)Component.text((String)"Resource pack is required!"));
        }
    }

    @EventHandler
    public void onConnectionDrop(PlayerConnectionCloseEvent e) {
        CountDownLatch latch = this.waitingConfigurationThreads.get(e.getPlayerUniqueId());
        if (latch == null) {
            return;
        }
        while (latch.getCount() > 0L) {
            latch.countDown();
        }
        this.p.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this.p, () -> this.waitingConfigurationThreads.remove(e.getPlayerUniqueId()), 5L);
    }
}

