/*
 * Decompiled with CFR 0.152.
 */
package com.github.cinnamondev.minemoji.PackMaker;

import com.github.cinnamondev.minemoji.EmojiSet;
import com.google.gson.Gson;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.math.NumberUtils;

public class PackMaker {
    private static final Options cliOptions = new Options();
    protected static int MIN_RP_VERSION;
    protected static int MAX_RP_VERSION;
    protected static int DEFAULT_FRAMERATE;

    protected static void generatePackMCMeta(CLIArgs args) throws IOException {
        File file = args.outputDirectory.toPath().resolve("pack.mcmeta").toFile();
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(file, false));
        bw.write("{\"pack\": {\"description\": \"Minemoji Emoji Pack\",\"min_format\":" + MIN_RP_VERSION + ",\"max_format\":" + args.maxVersion + "}}");
        bw.close();
    }

    protected static Path texturesFolder(CLIArgs args) throws IOException {
        Path basePath = args.outputDirectory.toPath();
        Path path = basePath.resolve("assets/minecraft/textures/" + args.prefix);
        path.toFile().mkdirs();
        return path;
    }

    protected static void generateAtlas(CLIArgs args) throws IOException {
        File file = args.outputDirectory.toPath().resolve("assets/minecraft/atlases/" + args.atlas + ".json").toFile();
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(file, false));
        bw.write("{\"sources\": [{\"type\": \"directory\", \"source\": \"" + args.prefix + "\", \"prefix\": \"" + args.prefix + "/\"}]}");
        bw.close();
    }

    protected static int getFramerateOrDefault(@Nullable File infoFile) throws IOException {
        if (!infoFile.exists()) {
            return DEFAULT_FRAMERATE;
        }
        try (BufferedReader bw = new BufferedReader(new FileReader(infoFile));){
            String unparsedLine = bw.readLine();
            if (NumberUtils.isCreatable((String)unparsedLine)) {
                int n = Integer.parseInt(unparsedLine);
                return n;
            }
            int n = DEFAULT_FRAMERATE;
            return n;
        }
    }

    protected static File resolveInfoFile(File file) {
        return file.getParentFile().toPath().resolve(file.getName() + ".info").toFile();
    }

    public static void processSvg(CLIArgs args, File file, File outFile) throws IOException, TranscoderException {
        PNGTranscoder t = new PNGTranscoder();
        t.addTranscodingHint(PNGTranscoder.KEY_WIDTH, Float.valueOf(args.keyWidth));
        t.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, Float.valueOf(args.keyWidth));
        TranscoderInput input = new TranscoderInput(new FileInputStream(file));
        FileOutputStream out = new FileOutputStream(outFile);
        TranscoderOutput output = new TranscoderOutput(out);
        t.transcode(input, output);
        out.flush();
        ((OutputStream)out).close();
    }

    private static IIOMetadataNode getNode(IIOMetadataNode rootNode, String nodeName) {
        int nNodes = rootNode.getLength();
        for (int i = 0; i < nNodes; ++i) {
            if (rootNode.item(i).getNodeName().compareToIgnoreCase(nodeName) != 0) continue;
            return (IIOMetadataNode)rootNode.item(i);
        }
        IIOMetadataNode node = new IIOMetadataNode(nodeName);
        rootNode.appendChild(node);
        return node;
    }

    protected static int getDelayTimeFromCurrentStream(ImageReader gifReader, int frame) throws IOException {
        String formatName;
        IIOMetadata meta = gifReader.getImageMetadata(frame);
        IIOMetadataNode root = (IIOMetadataNode)meta.getAsTree(formatName = meta.getNativeMetadataFormatName());
        IIOMetadataNode graphicsController = PackMaker.getNode(root, "GraphicControlExtension");
        String unparsedTime = graphicsController.getAttribute("delayTime");
        int time = Integer.parseInt(unparsedTime);
        return time != 0 ? time : 10;
    }

    protected static int modeOfList(List<Integer> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("list is empty");
        }
        return list.stream().filter(f -> f != -1).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElseThrow();
    }

    protected static void processGif(CLIArgs args, ImageReader gifReader, File file, File outFile, File mcmetaFile) throws IOException {
        int maxFramerate = PackMaker.getFramerateOrDefault(PackMaker.resolveInfoFile(file));
        if (maxFramerate > 20) {
            maxFramerate = 20;
        }
        ArrayList<Integer> frameTimes = new ArrayList<Integer>();
        ImageInputStream stream = ImageIO.createImageInputStream(file);
        gifReader.setInput(stream);
        int n = gifReader.getNumImages(true);
        BufferedImage output = new BufferedImage(args.keyWidth, args.keyWidth * n, 2);
        Graphics2D g2d = output.createGraphics();
        g2d.setBackground(new Color(0.0f, 0.0f, 0.0f, 1.0f));
        for (int i = 0; i < n; ++i) {
            BufferedImage frame = gifReader.read(i);
            Image newFrame = frame.getScaledInstance(args.keyWidth, args.keyWidth, 4);
            g2d.drawImage(newFrame, 0, args.keyWidth * i, null);
            frameTimes.add(PackMaker.getDelayTimeFromCurrentStream(gifReader, i));
        }
        g2d.dispose();
        ImageIO.write((RenderedImage)output, "png", outFile);
        int mode = PackMaker.modeOfList(frameTimes);
        int minDelay = 10000 / maxFramerate;
        int minDelayTicks = minDelay / 5;
        ArrayList<String> frames = new ArrayList<String>(frameTimes.size());
        boolean hasNonStandardFrames = false;
        for (int i = 0; i < frameTimes.size(); ++i) {
            Object frameOutput;
            int currentFrame = frameTimes.get(i);
            if (currentFrame == mode || currentFrame == -1) {
                frameOutput = String.valueOf(i);
            } else {
                hasNonStandardFrames = true;
                int currentFrameTicks = currentFrame < minDelayTicks ? minDelayTicks : currentFrame / 5;
                frameOutput = "{\"index\": " + i + ",\"time\":" + currentFrameTicks + "}";
            }
            frames.add((String)frameOutput);
        }
        if (!mcmetaFile.exists()) {
            mcmetaFile.createNewFile();
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(mcmetaFile));){
            int frametime = mode / 5;
            bw.write("{\"animation\": {\"frametime\":" + (frametime != 0 ? frametime : 1) + (String)(hasNonStandardFrames ? ",\"frames\": [" + String.join((CharSequence)",", frames) + "]" : "") + "}}");
        }
        stream.close();
    }

    protected static void genericTranscodeResize(CLIArgs args, File file, File outFile) throws IOException {
        ImageInputStream s = ImageIO.createImageInputStream(file);
        BufferedImage image = ImageIO.read(s);
        Image scaledImage = image.getScaledInstance(args.keyWidth, args.keyWidth, 4);
        BufferedImage newImage = new BufferedImage(args.keyWidth, args.keyWidth, 2);
        Graphics2D g2d = newImage.createGraphics();
        g2d.drawImage(scaledImage, 0, 0, null);
        g2d.dispose();
        ImageIO.write((RenderedImage)newImage, "png", outFile);
    }

    public static void zipFiles(File sourceFolder, File zipFile) throws IOException {
        if (!sourceFolder.exists()) {
            throw new IllegalArgumentException("source doesnt exist");
        }
        if (!sourceFolder.isDirectory()) {
            throw new IllegalArgumentException("source is not a directory :(");
        }
        if (zipFile.exists()) {
            zipFile.delete();
        }
        zipFile.createNewFile();
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));){
            Files.walk(sourceFolder.toPath(), new FileVisitOption[0]).filter(p -> p.toFile().isFile()).forEach(p -> {
                ZipEntry ze = new ZipEntry(sourceFolder.toPath().relativize((Path)p).toString());
                try {
                    out.putNextEntry(ze);
                    Files.copy(p, out);
                    out.closeEntry();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public static void deleteDirectory(File directory) throws IOException {
        Files.walk(directory.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
    }

    public static void main(String[] __args) throws ParseException, URISyntaxException, IOException, TranscoderException {
        EmojiSet set;
        CLIArgs args = CLIArgs.fromOpts(__args);
        System.out.println(args);
        Path packJsonDirectory = Paths.get(PackMaker.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent().resolve("minemoji/packs/");
        if (!packJsonDirectory.toFile().exists() && args.createPackInfo) {
            packJsonDirectory.toFile().mkdirs();
        }
        Gson gson = new Gson();
        File jsonFile = packJsonDirectory.resolve(args.prefix + ".json").toFile();
        if (jsonFile.exists() && args.createPackInfo) {
            try (BufferedReader br = new BufferedReader(new FileReader(jsonFile));){
                set = gson.fromJson((Reader)br, EmojiSet.class);
                ++set.packVersion;
            }
        } else {
            set = new EmojiSet();
            set.packVersion = 1;
        }
        set.prefix = args.prefix;
        set.url = args.packUrl.toURI();
        set.serveToClient = args.serveToClient;
        System.out.println(set.prefix);
        if (!args.outputDirectory.exists()) {
            args.outputDirectory.mkdirs();
        }
        if (!args.inputDirectory.isDirectory() || !args.outputDirectory.isDirectory()) {
            throw new ParseException("invalid input / output directory");
        }
        ImageReader gifReader = ImageIO.getImageReadersByFormatName("gif").next();
        List<String> endings = Arrays.stream(ImageIO.getReaderFileSuffixes()).toList();
        ArrayList<EmojiSet.SpriteMeta> emojis = new ArrayList<EmojiSet.SpriteMeta>();
        for (File file : args.inputDirectory.listFiles()) {
            String baseString = file.getName().substring(0, file.getName().lastIndexOf(46)).toLowerCase();
            String resourceName = baseString.replace('~', '-');
            String fileEnding = file.getName().substring(file.getName().lastIndexOf(46) + 1);
            File outputFile = PackMaker.texturesFolder(args).resolve(resourceName + ".png").toFile();
            switch (fileEnding) {
                case "svg": {
                    PackMaker.processSvg(args, file, outputFile);
                    break;
                }
                case "gif": {
                    PackMaker.processGif(args, gifReader, file, outputFile, PackMaker.texturesFolder(args).resolve(resourceName + ".png.mcmeta").toFile());
                    break;
                }
                default: {
                    if (!endings.contains(fileEnding)) break;
                    PackMaker.genericTranscodeResize(args, file, outputFile);
                }
            }
            String spriteName = baseString.replace('.', '-');
            if (!args.createPackInfo) continue;
            emojis.add(new EmojiSet.SpriteMeta(baseString.replace('.', '-'), args.prefix + "/" + resourceName));
        }
        set.emojis = emojis;
        if (args.createPackInfo) {
            if (!jsonFile.exists()) {
                jsonFile.createNewFile();
            }
            set.emojis = emojis;
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(jsonFile, false));){
                gson.toJson((Object)set, (Appendable)bw);
            }
            Files.copy(jsonFile.toPath(), new File(String.valueOf(args.outputDirectory) + "/pack.json").toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        PackMaker.generateAtlas(args);
        PackMaker.generatePackMCMeta(args);
        if (args.createZip) {
            String zipName = args.outputDirectory.getName() + ".zip";
            System.out.println(args.outputDirectory.getParentFile().toPath().resolve(zipName).toFile());
            PackMaker.zipFiles(args.outputDirectory, args.outputDirectory.getParentFile().toPath().resolve(zipName).toFile());
        }
        if (args.deleteDirectory && args.outputDirectory.exists()) {
            PackMaker.deleteDirectory(args.outputDirectory);
        }
    }

    static {
        Option inDir = new Option("i", "input-directory", true, "location containing images + .info files");
        inDir.setRequired(true);
        inDir.setType(File.class);
        cliOptions.addOption(inDir);
        Option outDir = new Option("o", "output-directory", true, "resource pack root. if this is zipped, the filename will be this + .zip.");
        outDir.setRequired(true);
        outDir.setType(File.class);
        cliOptions.addOption(outDir);
        Option prefix = new Option("p", "prefix", true, "prefix used for recognizing and in sprite folder");
        prefix.setRequired(true);
        cliOptions.addOption(prefix);
        Option packUrl = new Option("u", "pack-url", true, "url used to refer to pack for download");
        packUrl.setRequired(true);
        packUrl.setType(URL.class);
        cliOptions.addOption(packUrl);
        Option formatMaxVersion = new Option("max-version", true, "max version");
        formatMaxVersion.setRequired(false);
        formatMaxVersion.setType(Number.class);
        cliOptions.addOption(formatMaxVersion);
        Option emoteKeyWidth = new Option("w", "width", true, "width of emote key");
        emoteKeyWidth.setRequired(false);
        emoteKeyWidth.setType(Number.class);
        cliOptions.addOption(emoteKeyWidth);
        Option packgen = new Option("s", "skip-packgen", false, "skips generation of .json file");
        packgen.setRequired(false);
        cliOptions.addOption(packgen);
        Option createZip = new Option("z", "zip-pack", false, "zips up back");
        packgen.setRequired(false);
        cliOptions.addOption(createZip);
        Option zipDeleteDirectory = new Option("d", "delete-directory", false, "delete directory");
        zipDeleteDirectory.setRequired(false);
        cliOptions.addOption(zipDeleteDirectory);
        cliOptions.addOption("a", "atlas", true, "atlas key used. not rec to change.");
        cliOptions.addOption("v", "verbose", false, "verbose");
        cliOptions.addOption("c", "dontServe", false, "dont serve pack to client?");
        MIN_RP_VERSION = 69;
        MAX_RP_VERSION = 69;
        DEFAULT_FRAMERATE = 5;
    }

    protected record CLIArgs(File inputDirectory, File outputDirectory, URL packUrl, String prefix, String atlas, boolean createPackInfo, boolean verbose, int maxVersion, int keyWidth, boolean createZip, boolean deleteDirectory, boolean serveToClient) {
        public static CLIArgs fromOpts(String[] args) throws ParseException {
            DefaultParser parser = new DefaultParser();
            CommandLine commandLine = parser.parse(cliOptions, args);
            return new CLIArgs((File)commandLine.getParsedOptionValue("input-directory"), (File)commandLine.getParsedOptionValue("output-directory"), (URL)commandLine.getParsedOptionValue("pack-url"), (String)commandLine.getParsedOptionValue("prefix"), commandLine.getOptionValue("atlas", "paintings"), !commandLine.hasOption("skip-packgen"), commandLine.hasOption("verbose"), commandLine.hasOption("max-version") ? ((Number)commandLine.getParsedOptionValue("max-version")).intValue() : MAX_RP_VERSION, commandLine.hasOption("width") ? ((Number)commandLine.getParsedOptionValue("width")).intValue() : 32, commandLine.hasOption("zip-pack"), commandLine.hasOption("delete-directory") && commandLine.hasOption("zip-pack"), !commandLine.hasOption("serve"));
        }
    }
}

