/*
 * Decompiled with CFR 0.152.
 */
package com.github.cinnamondev.minemoji;

import com.github.cinnamondev.minemoji.Command;
import com.github.cinnamondev.minemoji.DiscordIntegration;
import com.github.cinnamondev.minemoji.EmojiRenderer;
import com.github.cinnamondev.minemoji.RequestPacks;
import com.github.cinnamondev.minemoji.SpriteEmojiManager;
import github.scarsz.discordsrv.DiscordSRV;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Minemoji
extends JavaPlugin {
    public static final URI DEFAULT_URI = URI.create("https://cinnamondev.github.io/minemoji/packs/twemoji-latest.zip");
    private Command command;
    public DiscordIntegration discord = null;

    public void onEnable() {
        CompletableFuture<SpriteEmojiManager> managerFuture;
        this.saveDefaultConfig();
        if (!this.getConfig().getBoolean("custom-packs.download", false)) {
            managerFuture = CompletableFuture.completedFuture(SpriteEmojiManager.fromLocalPacks(this, this.getDataPath().resolve("packs").toFile()));
        } else {
            ArrayList<URI> uris = new ArrayList<URI>();
            for (String s : this.getConfig().getStringList("custom-packs.packs")) {
                try {
                    uris.add(new URI(s));
                }
                catch (URISyntaxException e) {
                    this.getComponentLogger().warn("Malformed URI " + s + " in custom packs list.");
                }
            }
            managerFuture = SpriteEmojiManager.fromRemotePacks(this, uris);
        }
        ((CompletableFuture)managerFuture.thenAccept(m -> {})).exceptionally(ex -> {
            this.getLogger().warning("Couldn't make sprite manager, plugin will be dud!\n" + ex.getMessage());
            return null;
        });
        if (this.getConfig().getBoolean("serve-packs", true)) {
            ((CompletableFuture)((CompletableFuture)managerFuture.thenComposeAsync(manager -> {
                try {
                    return RequestPacks.requestPacks(this, manager);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            })).thenAccept(listener -> this.getServer().getPluginManager().registerEvents((Listener)listener, (Plugin)this))).exceptionally(ex -> {
                this.getComponentLogger().warn("Couldn't make pack listener, see:", ex);
                return null;
            });
        }
        ((CompletableFuture)((CompletableFuture)managerFuture.thenApply(EmojiRenderer::new)).thenAccept(listener -> this.getServer().getPluginManager().registerEvents((Listener)listener, (Plugin)this))).exceptionally(ex -> {
            this.getComponentLogger().warn("Couldn't attach emoji chat renderer, see:", ex);
            return null;
        });
        if (this.getServer().getPluginManager().isPluginEnabled("DiscordSRV")) {
            ((CompletableFuture)((CompletableFuture)managerFuture.thenApply(manager -> new DiscordIntegration(this, (SpriteEmojiManager)manager))).thenAccept(integration -> {
                this.discord = integration;
                DiscordSRV.api.subscribe(integration);
            })).exceptionally(ex -> {
                this.getComponentLogger().warn("Couldn't start DiscordSRV integration: ", ex);
                return null;
            });
        }
        this.command = new Command(this);
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> ((Commands)commands.registrar()).register(this.command.command()));
        ((CompletableFuture)managerFuture.thenAccept(manager -> {
            this.command.registerCustomPacks(manager.getCustomPacks());
            this.command.registerDefaultPack(manager.getDefaultEmojiMap());
        })).exceptionally(ex -> {
            this.getComponentLogger().warn("Couldn't register packs to command... ", ex);
            return null;
        });
    }

    public void onDisable() {
        if (this.discord != null) {
            DiscordSRV.api.unsubscribe((Object)this.discord);
        }
    }
}

