/*
 * Decompiled with CFR 0.152.
 */
package com.github.cinnamondev.minemoji;

import com.github.cinnamondev.minemoji.Minemoji;
import com.github.cinnamondev.minemoji.SpriteEmojiManager;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.DiscordGuildMessagePostProcessEvent;
import github.scarsz.discordsrv.api.events.GameChatMessagePreProcessEvent;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import java.util.regex.Pattern;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;

public class DiscordIntegration {
    private final SpriteEmojiManager manager;
    private final Minemoji p;
    private final TextReplacementConfig PREFIXED_EMOTE_REPLACER = (TextReplacementConfig)TextReplacementConfig.builder().match(Pattern.compile(":[a-zA-Z0-9_]*--([a-zA-Z0-9_~]*):")).replacement((result, b) -> net.kyori.adventure.text.Component.text((String)result.group(1))).build();

    public DiscordIntegration(Minemoji p, SpriteEmojiManager emojiManager) {
        this.p = p;
        this.manager = emojiManager;
    }

    private static net.kyori.adventure.text.Component fromShaded(Component discordComponent) {
        String jsonComponent = (String)github.scarsz.discordsrv.dependencies.kyori.adventure.text.serializer.gson.GsonComponentSerializer.gson().serialize(discordComponent);
        return GsonComponentSerializer.gson().deserialize((Object)jsonComponent);
    }

    private static Component toShaded(net.kyori.adventure.text.Component component) {
        String jsonComponent = (String)GsonComponentSerializer.gson().serialize(component);
        return github.scarsz.discordsrv.dependencies.kyori.adventure.text.serializer.gson.GsonComponentSerializer.gson().deserialize((Object)jsonComponent);
    }

    @Subscribe
    public void onMessageSent(DiscordGuildMessagePostProcessEvent e) {
        e.setCancelled(true);
        this.p.getServer().sendMessage(this.manager.emojize(DiscordIntegration.fromShaded(e.getMinecraftMessage())));
    }

    @Subscribe
    public void onMessageReceived(GameChatMessagePreProcessEvent e) {
        net.kyori.adventure.text.Component demojized = this.manager.demojize(DiscordIntegration.fromShaded(e.getMessageComponent()));
        demojized = demojized.replaceText(this.PREFIXED_EMOTE_REPLACER);
        e.setMessageComponent(DiscordIntegration.toShaded(demojized));
    }
}

