/*
 * Decompiled with CFR 0.152.
 */
package com.github.cinnamondev.minemoji;

import com.github.cinnamondev.minemoji.EmojiSet;
import com.github.cinnamondev.minemoji.Minemoji;
import com.github.cinnamondev.minemoji.SpriteEmojiManager;
import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fellbaum.jemoji.Emoji;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.ObjectComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public class Command {
    private final Minemoji p;
    private final LiteralCommandNode<CommandSourceStack> command;
    private Map<String, List<Component>> packPages = Collections.emptyMap();
    private List<Component> defaultPackPages = Collections.emptyList();

    public void registerCustomPacks(Map<String, EmojiSet> packs) {
        this.packPages = packs.entrySet().stream().map(e -> Map.entry((String)e.getKey(), Command.paginateComponents(((EmojiSet)e.getValue()).emojis.stream().map(emote -> this.emoteWithLore(SpriteEmojiManager.spriteMetaToComponent(emote), ":" + (String)e.getKey() + "--" + emote.emojiText + ":")).toList(), 8, 8))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void registerDefaultPack(Map<Emoji, ObjectComponent> pack) {
        this.defaultPackPages = Command.paginateComponents(pack.entrySet().stream().filter(e -> !((Emoji)e.getKey()).getDiscordAliases().isEmpty()).map(e -> this.emoteWithLore((ObjectComponent)e.getValue(), ((Emoji)e.getKey()).getDiscordAliases().getFirst())).toList(), 8, 8);
    }

    public Command(Minemoji p) {
        this.p = p;
        this.command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"minemoji").then(Commands.literal((String)"about").executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(((TextComponent)((TextComponent)Component.text((String)("Minemoji " + p.getPluginMeta().getVersion())).color((TextColor)NamedTextColor.LIGHT_PURPLE)).appendNewline()).append(((TextComponent)Component.text((String)"[Github]").style(Style.style((TextColor)NamedTextColor.AQUA, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).clickEvent(ClickEvent.openUrl((String)"https://github.com/cinnamondev/minemoji"))));
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").requires(src -> src.getSender().hasPermission("minemoji.list"))).then(((RequiredArgumentBuilder)Commands.argument((String)"pack", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            if ("unicode".startsWith(builder.getRemainingLowerCase())) {
                builder.suggest("unicode");
            }
            this.packPages.keySet().stream().filter(k -> k.toLowerCase().startsWith(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> this.listByPack((CommandContext<CommandSourceStack>)ctx, (String)ctx.getArgument("pack", String.class), (Integer)ctx.getArgument("page", Integer.class))))).executes(ctx -> this.listByPack((CommandContext<CommandSourceStack>)ctx, (String)ctx.getArgument("pack", String.class), 1)))).executes(ctx -> {
            Component text = Component.text((String)"All available custom emote packs").append(Component.join((JoinConfiguration)JoinConfiguration.newlines(), this.packPages.keySet().stream().map(str -> (TextComponent)((TextComponent)((TextComponent)Component.text((String)str).decorate(TextDecoration.UNDERLINED)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to show pack contents")))).clickEvent(ClickEvent.runCommand((String)("minemoji list " + str)))).toList()));
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(text);
            return 1;
        }))).then(Commands.literal((String)"help").executes(Command::helpCommand))).executes(Command::helpCommand)).build();
    }

    public LiteralCommandNode<CommandSourceStack> command() {
        return this.command;
    }

    private Component emoteWithLore(ObjectComponent component, String knownString) {
        return ((ObjectComponent)component.hoverEvent((HoverEventSource)HoverEvent.showText((Component)((TextComponent)Component.text((String)knownString).appendNewline()).append((Component)Component.text((String)"Click to copy to clipboard!"))))).clickEvent(ClickEvent.copyToClipboard((String)knownString));
    }

    private static List<Component> paginateComponents(List<Component> components, int columns, int rows) {
        return Lists.partition(components, (int)(columns * rows)).stream().map(l -> Component.join((JoinConfiguration)JoinConfiguration.newlines(), Lists.partition((List)l, (int)columns).stream().map(cs -> Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.text((String)" ")), (Iterable)cs)).toList())).toList();
    }

    private int listByPack(CommandContext<CommandSourceStack> context, String pack, int page) throws CommandSyntaxException {
        List<Component> list = pack.equalsIgnoreCase("unicode") ? this.defaultPackPages : this.packPages.get(pack);
        if (list == null || list.isEmpty()) {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage(Component.text((String)"No pack found!").color((TextColor)NamedTextColor.RED));
            return 1;
        }
        if (page > list.size() || page <= 0) {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage(Component.text((String)"Page does not exist").color((TextColor)NamedTextColor.RED));
            return 1;
        }
        ((CommandSourceStack)context.getSource()).getSender().sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)("Pack " + pack + ":")).appendNewline()).append(list.get(page - 1))).appendNewline()).append(Command.pageScroller(pack, page, list.size())));
        return 1;
    }

    private static Component pageScroller(String pack, int currentPage, int totalPages) {
        if (totalPages == 1) {
            return Component.empty();
        }
        Component backPage = ((TextComponent)Component.text((String)"[ << ]").decorate(TextDecoration.BOLD)).color((TextColor)NamedTextColor.GRAY);
        if (currentPage - 1 > 0) {
            backPage = backPage.color((TextColor)NamedTextColor.AQUA).clickEvent(ClickEvent.runCommand((String)("minemoji list " + pack + " " + (currentPage - 1))));
        }
        Component nextPage = ((TextComponent)Component.text((String)"[ >> ]").decorate(TextDecoration.BOLD)).color((TextColor)NamedTextColor.GRAY);
        if (currentPage + 1 <= totalPages) {
            nextPage = nextPage.color((TextColor)NamedTextColor.AQUA).clickEvent(ClickEvent.runCommand((String)("minemoji list " + pack + " " + (currentPage + 1))));
        }
        return backPage.append(Component.text((String)(" " + currentPage + "/" + totalPages + " ")).color((TextColor)NamedTextColor.YELLOW)).append(nextPage);
    }

    private static int helpCommand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ((CommandSourceStack)context.getSource()).getSender().sendMessage((Component)Component.text((String)"/minemoji list <pack-name|unicode>"));
        return 1;
    }
}

