/*
 * Decompiled with CFR 0.152.
 */
package me.byteful.plugin.leveltools.util;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class Text {
    private static final Set<Character> COLOR_CODES = new HashSet<Character>();
    private static final ThreadLocal<DecimalFormat> FORMAT;
    private static final char[] SUFFIXES;

    @NotNull
    public static String decolorize(@NotNull String string) {
        return Text.colorize(string).replace("\u00a7", "&");
    }

    @NotNull
    public static String colorize(String input) {
        StringBuilder builder = new StringBuilder();
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            if (i + 1 < len) {
                char n = input.charAt(i + 1);
                if (c == '\\' && (n == '&' || n == '\\')) {
                    builder.append(n);
                    ++i;
                    continue;
                }
                if (c == '&') {
                    String hexCode;
                    if (COLOR_CODES.contains(Character.valueOf(Character.toLowerCase(n)))) {
                        builder.append('\u00a7').append(Character.toLowerCase(n));
                        ++i;
                        continue;
                    }
                    if (n == '#' && i + 7 < len && (hexCode = input.substring(i + 2, i + 8)).chars().allMatch(Text::isHexChar)) {
                        builder.append('\u00a7').append('x');
                        for (char hc : hexCode.toCharArray()) {
                            builder.append('\u00a7').append(Character.toLowerCase(hc));
                        }
                        i += 7;
                        continue;
                    }
                }
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static boolean isHexChar(int c) {
        return c >= 48 && c <= 57 || c >= 65 && c <= 70 || c >= 97 && c <= 102;
    }

    public static String formatMoney(double money) {
        int i = -1;
        while (money >= 1000.0) {
            money /= 1000.0;
            ++i;
        }
        if (i >= 0) {
            return Text.truncateDouble(money) + SUFFIXES[i];
        }
        return Text.truncateDouble(money);
    }

    public static String truncateDouble(double input) {
        return FORMAT.get().format(input);
    }

    public static String[] substringsBetween(String str, String open, String close) {
        int end;
        int start;
        int strLen = str.length();
        int closeLen = close.length();
        int openLen = open.length();
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        while (pos < strLen - closeLen && (start = str.indexOf(open, pos)) >= 0 && (end = str.indexOf(close, start += openLen)) >= 0) {
            list.add(str.substring(start, end));
            pos = end + closeLen;
        }
        return list.isEmpty() ? null : list.toArray(new String[0]);
    }

    static {
        for (char c : "0123456789abcdefklmnor".toCharArray()) {
            COLOR_CODES.add(Character.valueOf(c));
        }
        FORMAT = ThreadLocal.withInitial(() -> new DecimalFormat("0.00"));
        SUFFIXES = new char[]{'K', 'M', 'B', 'T', 'Q'};
    }
}

