/*
 * Decompiled with CFR 0.152.
 */
package me.byteful.plugin.leveltools.profile.trigger;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import me.byteful.plugin.leveltools.api.trigger.TriggerType;
import me.byteful.plugin.leveltools.profile.trigger.TriggerFilter;
import me.byteful.plugin.leveltools.profile.trigger.TriggerProfile;
import me.byteful.plugin.leveltools.profile.trigger.TriggerSettings;
import me.byteful.plugin.leveltools.profile.trigger.XpModifierConfig;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;

public final class TriggerProfileLoader {
    private final Logger logger;

    public TriggerProfileLoader(@NotNull Logger logger) {
        this.logger = logger;
    }

    @NotNull
    public Map<String, TriggerProfile> load(@NotNull FileConfiguration config) {
        HashMap<String, TriggerProfile> profiles = new HashMap<String, TriggerProfile>();
        ConfigurationSection profilesSection = config.getConfigurationSection("profiles");
        if (profilesSection == null) {
            this.logger.warning("No trigger profiles found in trigger_profiles.yml");
            return profiles;
        }
        for (String profileId : profilesSection.getKeys(false)) {
            ConfigurationSection profileSection = profilesSection.getConfigurationSection(profileId);
            if (profileSection == null) continue;
            try {
                TriggerProfile profile = this.parseProfile(profileId, profileSection);
                profiles.put(profileId, profile);
            }
            catch (Exception e) {
                this.logger.severe("Failed to load trigger profile '" + profileId + "': " + e.getMessage());
            }
        }
        this.logger.info("Loaded " + profiles.size() + " trigger profile(s).");
        return profiles;
    }

    @NotNull
    private TriggerProfile parseProfile(@NotNull String id, @NotNull ConfigurationSection section) {
        String typeStr = section.getString("type");
        if (typeStr == null) {
            throw new IllegalArgumentException("Missing 'type' field");
        }
        TriggerType type = TriggerType.fromString(typeStr);
        if (type == null) {
            throw new IllegalArgumentException("Invalid trigger type: " + typeStr);
        }
        XpModifierConfig xpModifier = this.parseXpModifier(section.getConfigurationSection("xp_modifier"));
        TriggerFilter filter = this.parseFilter(section.getConfigurationSection("filter"));
        TriggerSettings settings = this.parseSettings(section, type);
        return TriggerProfile.builder(id).type(type).xpModifier(xpModifier).filter(filter).settings(settings).build();
    }

    @NotNull
    private XpModifierConfig parseXpModifier(ConfigurationSection section) {
        if (section == null) {
            return new XpModifierConfig(1.0, 1.0, Collections.emptyMap());
        }
        ConfigurationSection defaultSection = section.getConfigurationSection("default");
        double defaultMin = 1.0;
        double defaultMax = 1.0;
        if (defaultSection != null) {
            defaultMin = defaultSection.getDouble("min", 1.0);
            defaultMax = defaultSection.getDouble("max", 1.0);
        }
        HashMap<String, XpModifierConfig.XpModifierRange> customModifiers = new HashMap<String, XpModifierConfig.XpModifierRange>();
        ConfigurationSection customSection = section.getConfigurationSection("custom");
        if (customSection != null) {
            for (String key : customSection.getKeys(false)) {
                ConfigurationSection modSection = customSection.getConfigurationSection(key);
                if (modSection == null) continue;
                double min = modSection.getDouble("min", defaultMin);
                double max = modSection.getDouble("max", defaultMax);
                customModifiers.put(key.toUpperCase(), new XpModifierConfig.XpModifierRange(min, max));
            }
        }
        return new XpModifierConfig(defaultMin, defaultMax, customModifiers);
    }

    @NotNull
    private TriggerFilter parseFilter(ConfigurationSection section) {
        if (section == null) {
            return TriggerFilter.empty();
        }
        String typeStr = section.getString("type", "BLACKLIST");
        boolean whitelist = typeStr.equalsIgnoreCase("WHITELIST");
        List list = section.getStringList("list");
        HashSet<String> entries = new HashSet<String>();
        for (String entry : list) {
            entries.add(entry.toUpperCase());
        }
        return new TriggerFilter(whitelist, entries);
    }

    @NotNull
    private TriggerSettings parseSettings(@NotNull ConfigurationSection section, @NotNull TriggerType type) {
        switch (type) {
            case RIGHT_CLICK: 
            case LEFT_CLICK: {
                String clickModeStr = section.getString("click_mode", "ANY");
                TriggerSettings.ClickMode clickMode = TriggerSettings.ClickMode.fromString(clickModeStr);
                return TriggerSettings.forClick(clickMode);
            }
        }
        return TriggerSettings.empty();
    }
}

