/*
 * Decompiled with CFR 0.152.
 */
package me.byteful.plugin.leveltools.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import me.byteful.plugin.leveltools.profile.display.DisplayProfile;
import me.byteful.plugin.leveltools.profile.item.ItemProfile;
import me.byteful.plugin.leveltools.profile.reward.RewardProfile;
import me.byteful.plugin.leveltools.profile.trigger.TriggerProfile;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;

public final class ProfileValidator {
    private final Logger logger;

    public ProfileValidator(@NotNull Logger logger) {
        this.logger = logger;
    }

    @NotNull
    public ValidationResult validate(@NotNull Map<String, TriggerProfile> triggerProfiles, @NotNull Map<String, RewardProfile> rewardProfiles, @NotNull Map<String, DisplayProfile> displayProfiles, @NotNull Map<String, ItemProfile> itemProfiles) {
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> warnings = new ArrayList<String>();
        this.validateDuplicateMaterials(itemProfiles, errors);
        this.validateProfileReferences(itemProfiles, triggerProfiles, rewardProfiles, displayProfiles, errors);
        this.validateEmptyProfiles(itemProfiles, warnings);
        return new ValidationResult(errors, warnings);
    }

    private void validateDuplicateMaterials(@NotNull Map<String, ItemProfile> itemProfiles, @NotNull List<String> errors) {
        HashMap<Material, String> materialToProfile = new HashMap<Material, String>();
        for (ItemProfile profile : itemProfiles.values()) {
            for (Material material : profile.getMaterials()) {
                String existingProfile = (String)materialToProfile.get(material);
                if (existingProfile != null) {
                    errors.add("Material " + material.name() + " is defined in multiple profiles: '" + existingProfile + "' and '" + profile.getId() + "'");
                    continue;
                }
                materialToProfile.put(material, profile.getId());
            }
        }
    }

    private void validateProfileReferences(@NotNull Map<String, ItemProfile> itemProfiles, @NotNull Map<String, TriggerProfile> triggerProfiles, @NotNull Map<String, RewardProfile> rewardProfiles, @NotNull Map<String, DisplayProfile> displayProfiles, @NotNull List<String> errors) {
        for (ItemProfile itemProfile : itemProfiles.values()) {
            String displayId;
            String rewardId;
            String triggerId = itemProfile.getTriggerProfileId();
            if (!triggerProfiles.containsKey(triggerId)) {
                errors.add("Item profile '" + itemProfile.getId() + "' references unknown trigger profile: '" + triggerId + "'");
            }
            if (!rewardProfiles.containsKey(rewardId = itemProfile.getRewardProfileId())) {
                errors.add("Item profile '" + itemProfile.getId() + "' references unknown reward profile: '" + rewardId + "'");
            }
            if (displayProfiles.containsKey(displayId = itemProfile.getDisplayProfileId())) continue;
            errors.add("Item profile '" + itemProfile.getId() + "' references unknown display profile: '" + displayId + "'");
        }
    }

    private void validateEmptyProfiles(@NotNull Map<String, ItemProfile> itemProfiles, @NotNull List<String> warnings) {
        for (ItemProfile profile : itemProfiles.values()) {
            if (!profile.getMaterials().isEmpty()) continue;
            warnings.add("Item profile '" + profile.getId() + "' has no materials defined");
        }
    }

    public static final class ValidationResult {
        private final List<String> errors;
        private final List<String> warnings;

        public ValidationResult(@NotNull List<String> errors, @NotNull List<String> warnings) {
            this.errors = Collections.unmodifiableList(errors);
            this.warnings = Collections.unmodifiableList(warnings);
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        public boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }

        @NotNull
        public List<String> getErrors() {
            return this.errors;
        }

        @NotNull
        public List<String> getWarnings() {
            return this.warnings;
        }

        public void logTo(@NotNull Logger logger) {
            for (String warning : this.warnings) {
                logger.warning("[Profile Validation] " + warning);
            }
            for (String error : this.errors) {
                logger.severe("[Profile Validation] " + error);
            }
        }
    }
}

