/*
 * Decompiled with CFR 0.152.
 */
package me.byteful.plugin.leveltools.profile;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import me.byteful.plugin.leveltools.profile.ProfileValidator;
import me.byteful.plugin.leveltools.profile.display.DisplayProfile;
import me.byteful.plugin.leveltools.profile.display.DisplayProfileLoader;
import me.byteful.plugin.leveltools.profile.item.ItemProfile;
import me.byteful.plugin.leveltools.profile.item.ItemProfileLoader;
import me.byteful.plugin.leveltools.profile.reward.RewardProfile;
import me.byteful.plugin.leveltools.profile.reward.RewardProfileLoader;
import me.byteful.plugin.leveltools.profile.trigger.TriggerProfile;
import me.byteful.plugin.leveltools.profile.trigger.TriggerProfileLoader;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProfileManager {
    private final Logger logger;
    private final ProfileValidator validator;
    private final TriggerProfileLoader triggerLoader;
    private final RewardProfileLoader rewardLoader;
    private final DisplayProfileLoader displayLoader;
    private final ItemProfileLoader itemLoader;
    private volatile Map<String, TriggerProfile> triggerProfiles = Collections.emptyMap();
    private volatile Map<String, RewardProfile> rewardProfiles = Collections.emptyMap();
    private volatile Map<String, DisplayProfile> displayProfiles = Collections.emptyMap();
    private volatile Map<String, ItemProfile> itemProfiles = Collections.emptyMap();
    private volatile Map<Material, ItemProfile> materialToProfile = Collections.emptyMap();

    public ProfileManager(@NotNull Logger logger) {
        this.logger = logger;
        this.validator = new ProfileValidator(logger);
        this.triggerLoader = new TriggerProfileLoader(logger);
        this.rewardLoader = new RewardProfileLoader(logger);
        this.displayLoader = new DisplayProfileLoader(logger);
        this.itemLoader = new ItemProfileLoader(logger);
    }

    public void load(@NotNull FileConfiguration triggerConfig, @NotNull FileConfiguration rewardConfig, @NotNull FileConfiguration displayConfig, @NotNull FileConfiguration itemConfig) {
        Map<String, TriggerProfile> newTriggerProfiles = this.triggerLoader.load(triggerConfig);
        Map<String, RewardProfile> newRewardProfiles = this.rewardLoader.load(rewardConfig);
        Map<String, DisplayProfile> newDisplayProfiles = this.displayLoader.load(displayConfig);
        Map<String, ItemProfile> newItemProfiles = this.itemLoader.load(itemConfig);
        ProfileValidator.ValidationResult result = this.validator.validate(newTriggerProfiles, newRewardProfiles, newDisplayProfiles, newItemProfiles);
        result.logTo(this.logger);
        if (result.hasErrors()) {
            throw new IllegalStateException("Profile validation failed with " + result.getErrors().size() + " error(s). Check the logs above.");
        }
        Map<Material, ItemProfile> newMaterialToProfile = this.buildMaterialMapping(newItemProfiles);
        this.triggerProfiles = Collections.unmodifiableMap(newTriggerProfiles);
        this.rewardProfiles = Collections.unmodifiableMap(newRewardProfiles);
        this.displayProfiles = Collections.unmodifiableMap(newDisplayProfiles);
        this.itemProfiles = Collections.unmodifiableMap(newItemProfiles);
        this.materialToProfile = Collections.unmodifiableMap(newMaterialToProfile);
        this.logger.info("Profile system initialized successfully.");
    }

    @NotNull
    private Map<Material, ItemProfile> buildMaterialMapping(@NotNull Map<String, ItemProfile> items) {
        HashMap<Material, ItemProfile> mapping = new HashMap<Material, ItemProfile>();
        for (ItemProfile profile : items.values()) {
            for (Material material : profile.getMaterials()) {
                mapping.put(material, profile);
            }
        }
        this.logger.info("Mapped " + mapping.size() + " material(s) to item profiles.");
        return mapping;
    }

    public void clear() {
        this.triggerProfiles = Collections.emptyMap();
        this.rewardProfiles = Collections.emptyMap();
        this.displayProfiles = Collections.emptyMap();
        this.itemProfiles = Collections.emptyMap();
        this.materialToProfile = Collections.emptyMap();
    }

    @Nullable
    public ItemProfile getProfileForMaterial(@NotNull Material material) {
        return this.materialToProfile.get(material);
    }

    public boolean hasMaterialProfile(@NotNull Material material) {
        return this.materialToProfile.containsKey(material);
    }

    @Nullable
    public TriggerProfile getTriggerProfile(@NotNull String id) {
        return this.triggerProfiles.get(id);
    }

    @Nullable
    public RewardProfile getRewardProfile(@NotNull String id) {
        return this.rewardProfiles.get(id);
    }

    @Nullable
    public DisplayProfile getDisplayProfile(@NotNull String id) {
        return this.displayProfiles.get(id);
    }

    @Nullable
    public ItemProfile getItemProfile(@NotNull String id) {
        return this.itemProfiles.get(id);
    }

    @Nullable
    public TriggerProfile getTriggerProfileFor(@NotNull ItemProfile itemProfile) {
        return this.triggerProfiles.get(itemProfile.getTriggerProfileId());
    }

    @Nullable
    public RewardProfile getRewardProfileFor(@NotNull ItemProfile itemProfile) {
        return this.rewardProfiles.get(itemProfile.getRewardProfileId());
    }

    @Nullable
    public DisplayProfile getDisplayProfileFor(@NotNull ItemProfile itemProfile) {
        return this.displayProfiles.get(itemProfile.getDisplayProfileId());
    }

    @NotNull
    public Collection<TriggerProfile> getTriggerProfiles() {
        return Collections.unmodifiableCollection(this.triggerProfiles.values());
    }

    @NotNull
    public Collection<RewardProfile> getRewardProfiles() {
        return Collections.unmodifiableCollection(this.rewardProfiles.values());
    }

    @NotNull
    public Collection<DisplayProfile> getDisplayProfiles() {
        return Collections.unmodifiableCollection(this.displayProfiles.values());
    }

    @NotNull
    public Collection<ItemProfile> getItemProfiles() {
        return Collections.unmodifiableCollection(this.itemProfiles.values());
    }

    @NotNull
    public Set<String> getTriggerProfileIds() {
        return Collections.unmodifiableSet(this.triggerProfiles.keySet());
    }

    @NotNull
    public Set<String> getRewardProfileIds() {
        return Collections.unmodifiableSet(this.rewardProfiles.keySet());
    }

    @NotNull
    public Set<String> getDisplayProfileIds() {
        return Collections.unmodifiableSet(this.displayProfiles.keySet());
    }

    @NotNull
    public Set<String> getItemProfileIds() {
        return Collections.unmodifiableSet(this.itemProfiles.keySet());
    }
}

