/*
 * Decompiled with CFR 0.152.
 */
package me.byteful.plugin.leveltools.libs.xseries.reflection.aggregate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import me.byteful.plugin.leveltools.libs.xseries.reflection.ReflectiveHandle;
import me.byteful.plugin.leveltools.libs.xseries.reflection.XReflection;
import me.byteful.plugin.leveltools.libs.xseries.reflection.jvm.objects.ReflectedObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AggregateReflectiveHandle<T, H extends ReflectiveHandle<T>>
implements ReflectiveHandle<T> {
    private final List<Callable<H>> handles;
    private Consumer<H> handleModifier;

    @ApiStatus.Internal
    public AggregateReflectiveHandle(Collection<Callable<H>> handles) {
        this.handles = new ArrayList<Callable<H>>(handles.size());
        this.handles.addAll(handles);
    }

    public AggregateReflectiveHandle<T, H> or(@NotNull H handle) {
        return this.or(() -> handle);
    }

    public AggregateReflectiveHandle<T, H> or(@NotNull Callable<H> handle) {
        this.handles.add(handle);
        return this;
    }

    public AggregateReflectiveHandle<T, H> modify(@Nullable Consumer<H> handleModifier) {
        this.handleModifier = handleModifier;
        return this;
    }

    public H getHandle() {
        Throwable errors = null;
        for (Callable<H> handle : this.handles) {
            try {
                ReflectiveHandle handled = (ReflectiveHandle)handle.call();
                if (this.handleModifier != null) {
                    this.handleModifier.accept(handled);
                }
                if (!handled.exists()) {
                    handled.reflect();
                }
                return (H)handled;
            }
            catch (Throwable ex) {
                if (errors == null) {
                    errors = new ClassNotFoundException("None of the aggregate handles were successful");
                }
                errors.addSuppressed(ex);
            }
        }
        throw XReflection.throwCheckedException(XReflection.relativizeSuppressedExceptions(errors));
    }

    public AggregateReflectiveHandle<T, H> copy() {
        AggregateReflectiveHandle<T, H> handle = new AggregateReflectiveHandle<T, H>(new ArrayList<Callable<H>>(this.handles));
        handle.handleModifier = this.handleModifier;
        return handle;
    }

    @Override
    @NotNull
    public ReflectiveHandle<ReflectedObject> jvm() {
        return this.getHandle().jvm();
    }

    @Override
    public T reflect() throws ReflectiveOperationException {
        Throwable errors = null;
        for (Callable<H> handle : this.handles) {
            ReflectiveHandle handled;
            block7: {
                try {
                    handled = (ReflectiveHandle)handle.call();
                    if (this.handleModifier == null) break block7;
                    this.handleModifier.accept(handled);
                }
                catch (Throwable ex) {
                    if (errors == null) {
                        errors = new ClassNotFoundException("None of the aggregate handles were successful");
                    }
                    errors.addSuppressed(ex);
                    continue;
                }
            }
            try {
                return handled.reflect();
            }
            catch (Throwable ex) {
                if (errors == null) {
                    errors = new ClassNotFoundException("None of the aggregate handles were successful");
                }
                errors.addSuppressed(ex);
            }
        }
        throw (ClassNotFoundException)XReflection.relativizeSuppressedExceptions(errors);
    }
}

