/*
 * Decompiled with CFR 0.152.
 */
package me.byteful.plugin.leveltools.libs.lamp.util;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class Either<A, B> {
    public static <A, B> Either<A, B> first(A value) {
        return new First(value);
    }

    public static <A, B> Either<A, B> second(B value) {
        return new Second(value);
    }

    public abstract Optional<A> first();

    public abstract Optional<B> second();

    public boolean isFirst() {
        return this instanceof First;
    }

    public boolean isSecond() {
        return this instanceof Second;
    }

    public abstract Either<A, B> ifFirst(Consumer<A> var1);

    public abstract Either<A, B> ifSecond(Consumer<B> var1);

    public Either<B, A> swap() {
        return this.map(Either::second, Either::first);
    }

    public abstract <T> T map(Function<? super A, ? extends T> var1, Function<? super B, ? extends T> var2);

    public <T> Either<T, B> mapFirst(Function<? super A, ? extends T> function) {
        return this.map(t -> Either.first(function.apply((Object)t)), Either::second);
    }

    public <T> Either<A, T> mapSecond(Function<? super B, ? extends T> function) {
        return this.map(Either::first, t -> Either.second(function.apply((Object)t)));
    }

    private static class Second<A, B>
    extends Either<A, B> {
        private final B value;
        private Optional<B> valueOptional;

        Second(B value) {
            this.value = value;
        }

        @Override
        public Optional<A> first() {
            return Optional.empty();
        }

        @Override
        public Optional<B> second() {
            return this.valueOptional == null ? (this.valueOptional = Optional.of(this.value)) : this.valueOptional;
        }

        @Override
        public Either<A, B> ifFirst(Consumer<A> action) {
            return this;
        }

        @Override
        public Either<A, B> ifSecond(Consumer<B> action) {
            action.accept(this.value);
            return this;
        }

        @Override
        public <T> T map(Function<? super A, ? extends T> mapFirst, Function<? super B, ? extends T> mapSecond) {
            return mapSecond.apply(this.value);
        }

        public String toString() {
            return "Second{value=" + this.value + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Second) {
                Second first = (Second)o;
                return this.value.equals(first.value);
            }
            if (o instanceof First) {
                First second = (First)o;
                return this.value.equals(second.value);
            }
            return this.value.equals(o);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    private static class First<A, B>
    extends Either<A, B> {
        private final A value;
        private Optional<A> valueOptional;

        First(A value) {
            this.value = value;
        }

        @Override
        public Optional<A> first() {
            return this.valueOptional == null ? (this.valueOptional = Optional.of(this.value)) : this.valueOptional;
        }

        @Override
        public Optional<B> second() {
            return Optional.empty();
        }

        @Override
        public Either<A, B> ifFirst(Consumer<A> action) {
            action.accept(this.value);
            return this;
        }

        @Override
        public Either<A, B> ifSecond(Consumer<B> action) {
            return this;
        }

        @Override
        public <T> T map(Function<? super A, ? extends T> mapFirst, Function<? super B, ? extends T> mapSecond) {
            return mapFirst.apply(this.value);
        }

        public String toString() {
            return "First{value=" + this.value + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Second) {
                Second first = (Second)o;
                return this.value.equals(first.value);
            }
            if (o instanceof First) {
                First second = (First)o;
                return this.value.equals(second.value);
            }
            return this.value.equals(o);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

