/*
 * Decompiled with CFR 0.152.
 */
package me.byteful.plugin.leveltools.libs.lamp.orphan;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.byteful.plugin.leveltools.libs.lamp.core.CommandPath;
import me.byteful.plugin.leveltools.libs.lamp.orphan.OrphanCommand;
import me.byteful.plugin.leveltools.libs.lamp.orphan.OrphanRegistry;
import me.byteful.plugin.leveltools.libs.lamp.util.Preconditions;
import me.byteful.plugin.leveltools.libs.lamp.util.Strings;
import org.jetbrains.annotations.NotNull;

public final class Orphans {
    private final List<CommandPath> path;

    public static Orphans path(@NotNull String path) {
        Preconditions.notNull(path, "path");
        return new Orphans(Collections.singletonList(CommandPath.get(Strings.splitBySpace(path.trim()))));
    }

    public static Orphans path(String ... paths) {
        Preconditions.notNull(paths, "paths");
        return new Orphans(Arrays.stream(paths).map(text -> Strings.splitBySpace(text.trim())).map(CommandPath::get).collect(Collectors.toList()));
    }

    public static Orphans path(@NotNull CommandPath path) {
        Preconditions.notNull(path, "path");
        return new Orphans(Collections.singletonList(path));
    }

    public OrphanRegistry handler(OrphanCommand handler) {
        Preconditions.notNull(handler, "orphan command");
        return new OrphanRegistry(this.path, handler);
    }

    public Orphans(List<CommandPath> path) {
        this.path = path;
    }
}

