/*
 * Decompiled with CFR 0.152.
 */
package me.byteful.plugin.leveltools.libs.lamp.core;

import java.util.HashMap;
import me.byteful.plugin.leveltools.libs.lamp.annotation.CaseSensitive;
import me.byteful.plugin.leveltools.libs.lamp.command.CommandParameter;
import me.byteful.plugin.leveltools.libs.lamp.exception.EnumNotFoundException;
import me.byteful.plugin.leveltools.libs.lamp.process.ValueResolver;
import me.byteful.plugin.leveltools.libs.lamp.process.ValueResolverFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

enum EnumResolverFactory implements ValueResolverFactory
{
    INSTANCE;


    @Override
    @Nullable
    public ValueResolver<?> create(@NotNull CommandParameter parameter) {
        Class<?> type = parameter.getType();
        if (!type.isEnum()) {
            return null;
        }
        Class<Enum> enumType = type.asSubclass(Enum.class);
        HashMap<String, Enum> values = new HashMap<String, Enum>();
        boolean caseSensitive = parameter.hasAnnotation(CaseSensitive.class);
        for (Enum enumConstant : enumType.getEnumConstants()) {
            if (caseSensitive) {
                values.put(enumConstant.name(), enumConstant);
                continue;
            }
            values.put(enumConstant.name().toLowerCase(), enumConstant);
        }
        return context -> {
            String value = context.pop();
            Enum v = (Enum)values.get(caseSensitive ? value : value.toLowerCase());
            if (v == null) {
                throw new EnumNotFoundException(parameter, value);
            }
            return v;
        };
    }
}

