/*
 * Decompiled with CFR 0.152.
 */
package me.byteful.plugin.leveltools.config.migration;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public final class V1ToV2Migration {
    private final YamlConfiguration oldConfig;
    private final Path dataFolder;
    private final Logger logger;
    private static final String CONFIG_HEADER = "#\n# LevelTools by byteful\n#\n# Wiki: https://github.com/byteful/LevelTools/wiki/Configuration\n#\n\n";
    private static final String TRIGGER_HEADER = "#\n# Trigger Profiles - Define how XP is gained\n#\n# Wiki: https://github.com/byteful/LevelTools/wiki/Trigger-Profiles\n#\n\n";
    private static final String REWARD_HEADER = "#\n# Reward Profiles - Define rewards given at each level\n#\n# Wiki: https://github.com/byteful/LevelTools/wiki/Reward-Profiles\n#\n\n";
    private static final String DISPLAY_HEADER = "#\n# Display Profiles - Define how leveled items look\n#\n# Wiki: https://github.com/byteful/LevelTools/wiki/Display-Profiles\n#\n\n";
    private static final String ITEM_HEADER = "#\n# Item Profiles - Define which items can level up\n#\n# Wiki: https://github.com/byteful/LevelTools/wiki/Item-Profiles\n#\n\n";

    public V1ToV2Migration(@NotNull YamlConfiguration oldConfig, @NotNull Path dataFolder, @NotNull Logger logger) {
        this.oldConfig = oldConfig;
        this.dataFolder = dataFolder;
        this.logger = logger;
    }

    public void execute() {
        this.createNewMainConfig();
        this.createTriggerProfiles();
        this.createRewardProfiles();
        this.createDisplayProfiles();
        this.createItemProfiles();
        this.logger.info("v1 to v2 migration completed successfully.");
    }

    private void createNewMainConfig() {
        YamlConfiguration newConfig = new YamlConfiguration();
        newConfig.set("update.start", (Object)this.oldConfig.getBoolean("update.start", true));
        newConfig.set("update.periodically", (Object)this.oldConfig.getBoolean("update.periodically", true));
        newConfig.set("block_data_storage.type", (Object)this.oldConfig.getString("block_data_storage.type", "SQLITE"));
        this.copySection(this.oldConfig.getConfigurationSection("messages"), newConfig, "messages");
        newConfig.set("anvil_combine", (Object)this.oldConfig.getString("anvil_combine", "ADD_BOTH"));
        newConfig.set("level_xp_formula", (Object)this.oldConfig.getString("level_xp_formula", "100 + {current_level} * 100"));
        newConfig.set("playerPlacedBlocks", (Object)this.oldConfig.getBoolean("playerPlacedBlocks", false));
        this.copySection(this.oldConfig.getConfigurationSection("level_up_sound"), newConfig, "level_up_sound");
        newConfig.set("hide_attributes", (Object)this.oldConfig.getBoolean("hide_attributes", true));
        newConfig.set("disabled_worlds", (Object)this.oldConfig.getStringList("disabled_worlds"));
        this.saveConfig(newConfig, "config.yml", CONFIG_HEADER);
    }

    private void createTriggerProfiles() {
        YamlConfiguration triggerConfig = new YamlConfiguration();
        triggerConfig.set("profiles.block_mining.type", (Object)"BLOCK_BREAK");
        this.copyXpModifier(this.oldConfig, triggerConfig, "default_block_xp_modifier", "block_xp_modifiers", "profiles.block_mining.xp_modifier");
        this.copyFilter(this.oldConfig, triggerConfig, "block_list_type", "block_list", "profiles.block_mining.filter");
        triggerConfig.set("profiles.combat.type", (Object)"ENTITY_KILL");
        this.copyXpModifier(this.oldConfig, triggerConfig, "default_combat_xp_modifier", "combat_xp_modifiers", "profiles.combat.xp_modifier");
        this.copyFilter(this.oldConfig, triggerConfig, "entity_list_type", "entity_list", "profiles.combat.filter");
        triggerConfig.set("profiles.fishing.type", (Object)"FISHING");
        triggerConfig.set("profiles.fishing.xp_modifier.default.min", (Object)1.0);
        triggerConfig.set("profiles.fishing.xp_modifier.default.max", (Object)5.0);
        triggerConfig.set("profiles.fishing.filter.type", (Object)"BLACKLIST");
        triggerConfig.set("profiles.fishing.filter.list", Collections.emptyList());
        this.saveConfig(triggerConfig, "trigger_profiles.yml", TRIGGER_HEADER);
    }

    private void copyXpModifier(@NotNull YamlConfiguration source, @NotNull YamlConfiguration target, @NotNull String defaultKey, @NotNull String customKey, @NotNull String targetPath) {
        ConfigurationSection defaultSection = source.getConfigurationSection(defaultKey);
        if (defaultSection != null) {
            target.set(targetPath + ".default.min", (Object)defaultSection.getDouble("min", 1.0));
            target.set(targetPath + ".default.max", (Object)defaultSection.getDouble("max", 1.0));
        } else {
            target.set(targetPath + ".default.min", (Object)1.0);
            target.set(targetPath + ".default.max", (Object)1.0);
        }
        ConfigurationSection customSection = source.getConfigurationSection(customKey);
        if (customSection != null) {
            for (String key : customSection.getKeys(false)) {
                ConfigurationSection modSection = customSection.getConfigurationSection(key);
                if (modSection == null) continue;
                target.set(targetPath + ".custom." + key + ".min", (Object)modSection.getDouble("min"));
                target.set(targetPath + ".custom." + key + ".max", (Object)modSection.getDouble("max"));
            }
        }
    }

    private void copyFilter(@NotNull YamlConfiguration source, @NotNull YamlConfiguration target, @NotNull String typeKey, @NotNull String listKey, @NotNull String targetPath) {
        String filterType = source.getString(typeKey, "BLACKLIST");
        List filterList = source.getStringList(listKey);
        target.set(targetPath + ".type", (Object)filterType.toUpperCase());
        target.set(targetPath + ".list", (Object)filterList);
    }

    private void createRewardProfiles() {
        YamlConfiguration rewardConfig = new YamlConfiguration();
        this.migrateRewardSection(this.oldConfig, rewardConfig, "tool_rewards", "tools");
        this.migrateRewardSection(this.oldConfig, rewardConfig, "sword_rewards", "swords");
        this.migrateRewardSection(this.oldConfig, rewardConfig, "bow_rewards", "bows");
        rewardConfig.set("profiles.fishing_rods.levels.1", Collections.singletonList("enchant2 lure 1"));
        rewardConfig.set("profiles.fishing_rods.levels.5", Collections.singletonList("enchant2 luck_of_the_sea 1"));
        rewardConfig.set("profiles.fishing_rods.levels.10", Collections.singletonList("enchant2 lure 2"));
        rewardConfig.set("profiles.fishing_rods.levels.15", Collections.singletonList("enchant2 unbreaking 1"));
        rewardConfig.set("profiles.fishing_rods.levels.20", Collections.singletonList("enchant2 luck_of_the_sea 2"));
        rewardConfig.set("profiles.fishing_rods.levels.25", Collections.singletonList("enchant2 lure 3"));
        rewardConfig.set("profiles.fishing_rods.levels.30", Collections.singletonList("enchant2 unbreaking 2"));
        rewardConfig.set("profiles.fishing_rods.levels.35", Collections.singletonList("enchant2 luck_of_the_sea 3"));
        rewardConfig.set("profiles.fishing_rods.levels.40", Collections.singletonList("enchant2 unbreaking 3"));
        rewardConfig.set("profiles.fishing_rods.levels.50", Collections.singletonList("enchant2 mending 1"));
        this.saveConfig(rewardConfig, "reward_profiles.yml", REWARD_HEADER);
    }

    private void migrateRewardSection(@NotNull YamlConfiguration source, @NotNull YamlConfiguration target, @NotNull String sourceKey, @NotNull String profileId) {
        ConfigurationSection rewardsSection = source.getConfigurationSection(sourceKey);
        if (rewardsSection == null) {
            return;
        }
        for (String levelKey : rewardsSection.getKeys(false)) {
            List rewards = rewardsSection.getStringList(levelKey);
            target.set("profiles." + profileId + ".levels." + levelKey, (Object)rewards);
        }
    }

    private void createDisplayProfiles() {
        YamlConfiguration displayConfig = new YamlConfiguration();
        ConfigurationSection displaySection = this.oldConfig.getConfigurationSection("display");
        ConfigurationSection progressBar = this.oldConfig.getConfigurationSection("progress_bar");
        String basePath = "profiles.default";
        if (displaySection != null) {
            ConfigurationSection loreSection;
            ConfigurationSection actionBarSection;
            ConfigurationSection nameSection = displaySection.getConfigurationSection("name");
            if (nameSection != null) {
                displayConfig.set(basePath + ".name.enabled", (Object)nameSection.getBoolean("enabled", false));
                displayConfig.set(basePath + ".name.text", (Object)nameSection.getString("text", "{item} &7- &b{level}"));
            }
            if ((actionBarSection = displaySection.getConfigurationSection("actionBar")) != null) {
                displayConfig.set(basePath + ".action_bar.enabled", (Object)actionBarSection.getBoolean("enabled", true));
                displayConfig.set(basePath + ".action_bar.text", (Object)actionBarSection.getString("text", "{progress_bar} &e{xp_formatted}&6/&e{max_xp_formatted}"));
            }
            if ((loreSection = displaySection.getConfigurationSection("lore")) != null) {
                displayConfig.set(basePath + ".lore.enabled", (Object)loreSection.getBoolean("enabled", true));
                displayConfig.set(basePath + ".lore.lines", (Object)loreSection.getStringList("lines"));
            }
        }
        if (progressBar != null) {
            displayConfig.set(basePath + ".progress_bar.total_bars", (Object)progressBar.getInt("total_bars", 50));
            displayConfig.set(basePath + ".progress_bar.bar_symbol", (Object)progressBar.getString("bar_symbol", "|"));
            displayConfig.set(basePath + ".progress_bar.prefix_symbol", (Object)progressBar.getString("prefix_symbol", "["));
            displayConfig.set(basePath + ".progress_bar.suffix_symbol", (Object)progressBar.getString("suffix_symbol", "]"));
            displayConfig.set(basePath + ".progress_bar.prefix_color", (Object)progressBar.getString("prefix_color", "8"));
            displayConfig.set(basePath + ".progress_bar.suffix_color", (Object)progressBar.getString("suffix_color", "8"));
            displayConfig.set(basePath + ".progress_bar.completed_color", (Object)progressBar.getString("completed_color", "e"));
            displayConfig.set(basePath + ".progress_bar.placeholder_color", (Object)progressBar.getString("placeholder_color", "7"));
        }
        this.saveConfig(displayConfig, "display_profiles.yml", DISPLAY_HEADER);
    }

    private void createItemProfiles() {
        YamlConfiguration itemConfig = new YamlConfiguration();
        int maxLevel = this.oldConfig.getInt("max_level", 100);
        this.createToolProfile(itemConfig, "pickaxes", Arrays.asList("WOODEN_PICKAXE", "STONE_PICKAXE", "IRON_PICKAXE", "GOLDEN_PICKAXE", "DIAMOND_PICKAXE", "NETHERITE_PICKAXE"), "block_mining", "tools", "default", maxLevel);
        this.createToolProfile(itemConfig, "axes", Arrays.asList("WOODEN_AXE", "STONE_AXE", "IRON_AXE", "GOLDEN_AXE", "DIAMOND_AXE", "NETHERITE_AXE"), "block_mining", "tools", "default", maxLevel);
        this.createToolProfile(itemConfig, "shovels", Arrays.asList("WOODEN_SHOVEL", "STONE_SHOVEL", "IRON_SHOVEL", "GOLDEN_SHOVEL", "DIAMOND_SHOVEL", "NETHERITE_SHOVEL"), "block_mining", "tools", "default", maxLevel);
        this.createToolProfile(itemConfig, "swords", Arrays.asList("WOODEN_SWORD", "STONE_SWORD", "IRON_SWORD", "GOLDEN_SWORD", "DIAMOND_SWORD", "NETHERITE_SWORD"), "combat", "swords", "default", maxLevel);
        this.createToolProfile(itemConfig, "bows", Arrays.asList("BOW", "CROSSBOW"), "combat", "bows", "default", maxLevel);
        this.createToolProfile(itemConfig, "fishing_rods", Collections.singletonList("FISHING_ROD"), "fishing", "fishing_rods", "default", 50);
        this.saveConfig(itemConfig, "item_profiles.yml", ITEM_HEADER);
    }

    private void createToolProfile(@NotNull YamlConfiguration config, @NotNull String id, @NotNull List<String> materials, @NotNull String triggerProfile, @NotNull String rewardProfile, @NotNull String displayProfile, int maxLevel) {
        String basePath = "profiles." + id;
        config.set(basePath + ".materials", materials);
        config.set(basePath + ".trigger_profile", (Object)triggerProfile);
        config.set(basePath + ".reward_profile", (Object)rewardProfile);
        config.set(basePath + ".display_profile", (Object)displayProfile);
        config.set(basePath + ".max_level", (Object)maxLevel);
    }

    private void copySection(ConfigurationSection source, @NotNull YamlConfiguration target, @NotNull String path) {
        if (source == null) {
            return;
        }
        for (String key : source.getKeys(true)) {
            Object value = source.get(key);
            if (value instanceof ConfigurationSection) continue;
            target.set(path + "." + key, value);
        }
    }

    private void saveConfig(@NotNull YamlConfiguration config, @NotNull String filename, @NotNull String header) {
        try {
            String yamlContent = config.saveToString();
            String fullContent = header + yamlContent;
            Files.write(this.dataFolder.resolve(filename), fullContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.logger.info("Created " + filename);
        }
        catch (IOException e) {
            this.logger.severe("Failed to save " + filename + ": " + e.getMessage());
        }
    }
}

