/*
 * Decompiled with CFR 0.152.
 */
package me.byteful.plugin.leveltools.api.trigger;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import me.byteful.plugin.leveltools.api.trigger.Trigger;
import me.byteful.plugin.leveltools.api.trigger.TriggerType;
import me.byteful.plugin.leveltools.api.trigger.impl.BlockBreakTrigger;
import me.byteful.plugin.leveltools.api.trigger.impl.ConsumeTrigger;
import me.byteful.plugin.leveltools.api.trigger.impl.EntityKillTrigger;
import me.byteful.plugin.leveltools.api.trigger.impl.FishingTrigger;
import me.byteful.plugin.leveltools.api.trigger.impl.LeftClickTrigger;
import me.byteful.plugin.leveltools.api.trigger.impl.RightClickTrigger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TriggerRegistry {
    private final Map<TriggerType, Trigger> triggers = new EnumMap<TriggerType, Trigger>(TriggerType.class);

    public void register(@NotNull Trigger trigger) {
        this.triggers.put(trigger.getType(), trigger);
    }

    public void unregister(@NotNull TriggerType type) {
        this.triggers.remove((Object)type);
    }

    @Nullable
    public Trigger get(@NotNull TriggerType type) {
        return this.triggers.get((Object)type);
    }

    @NotNull
    public Optional<Trigger> getOptional(@NotNull TriggerType type) {
        return Optional.ofNullable(this.triggers.get((Object)type));
    }

    public boolean has(@NotNull TriggerType type) {
        return this.triggers.containsKey((Object)type);
    }

    @NotNull
    public Collection<Trigger> getAll() {
        return Collections.unmodifiableCollection(this.triggers.values());
    }

    public void clear() {
        this.triggers.clear();
    }

    public void registerDefaults() {
        this.register(new BlockBreakTrigger());
        this.register(new EntityKillTrigger());
        this.register(new FishingTrigger());
        this.register(new RightClickTrigger());
        this.register(new LeftClickTrigger());
        this.register(new ConsumeTrigger());
    }
}

