/*
 * Decompiled with CFR 0.152.
 */
package me.byteful.plugin.leveltools.api.trigger;

import me.byteful.plugin.leveltools.api.trigger.TriggerType;
import me.byteful.plugin.leveltools.profile.item.ItemProfile;
import me.byteful.plugin.leveltools.profile.trigger.TriggerProfile;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TriggerContext {
    private final Player player;
    private final ItemStack item;
    private final TriggerType triggerType;
    private final Object source;
    private final Event originalEvent;
    private final ItemProfile itemProfile;
    private final TriggerProfile triggerProfile;

    private TriggerContext(@NotNull Player player, @NotNull ItemStack item, @NotNull TriggerType triggerType, @Nullable Object source, @NotNull Event originalEvent, @NotNull ItemProfile itemProfile, @NotNull TriggerProfile triggerProfile) {
        this.player = player;
        this.item = item;
        this.triggerType = triggerType;
        this.source = source;
        this.originalEvent = originalEvent;
        this.itemProfile = itemProfile;
        this.triggerProfile = triggerProfile;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    @NotNull
    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    @Nullable
    public Object getSource() {
        return this.source;
    }

    @Nullable
    public <T> T getSourceAs(@NotNull Class<T> type) {
        if (type.isInstance(this.source)) {
            return (T)this.source;
        }
        return null;
    }

    @NotNull
    public Event getOriginalEvent() {
        return this.originalEvent;
    }

    @Nullable
    public <T extends Event> T getOriginalEventAs(@NotNull Class<T> type) {
        if (type.isInstance(this.originalEvent)) {
            return (T)this.originalEvent;
        }
        return null;
    }

    @NotNull
    public ItemProfile getItemProfile() {
        return this.itemProfile;
    }

    @NotNull
    public TriggerProfile getTriggerProfile() {
        return this.triggerProfile;
    }

    public static final class Builder {
        private Player player;
        private ItemStack item;
        private TriggerType triggerType;
        private Object source;
        private Event originalEvent;
        private ItemProfile itemProfile;
        private TriggerProfile triggerProfile;

        private Builder() {
        }

        public Builder player(@NotNull Player player) {
            this.player = player;
            return this;
        }

        public Builder item(@NotNull ItemStack item) {
            this.item = item;
            return this;
        }

        public Builder triggerType(@NotNull TriggerType triggerType) {
            this.triggerType = triggerType;
            return this;
        }

        public Builder source(@Nullable Object source) {
            this.source = source;
            return this;
        }

        public Builder originalEvent(@NotNull Event originalEvent) {
            this.originalEvent = originalEvent;
            return this;
        }

        public Builder itemProfile(@NotNull ItemProfile itemProfile) {
            this.itemProfile = itemProfile;
            return this;
        }

        public Builder triggerProfile(@NotNull TriggerProfile triggerProfile) {
            this.triggerProfile = triggerProfile;
            return this;
        }

        public TriggerContext build() {
            if (this.player == null) {
                throw new IllegalStateException("Player must be set");
            }
            if (this.item == null) {
                throw new IllegalStateException("Item must be set");
            }
            if (this.triggerType == null) {
                throw new IllegalStateException("TriggerType must be set");
            }
            if (this.originalEvent == null) {
                throw new IllegalStateException("Original event must be set");
            }
            if (this.itemProfile == null) {
                throw new IllegalStateException("ItemProfile must be set");
            }
            if (this.triggerProfile == null) {
                throw new IllegalStateException("TriggerProfile must be set");
            }
            return new TriggerContext(this.player, this.item, this.triggerType, this.source, this.originalEvent, this.itemProfile, this.triggerProfile);
        }
    }
}

