/*
 * Decompiled with CFR 0.152.
 */
package me.byteful.plugin.leveltools.api.item;

import me.byteful.plugin.leveltools.LevelToolsPlugin;
import me.byteful.plugin.leveltools.util.LevelToolsUtil;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import redempt.crunch.CompiledExpression;

public interface LevelToolsItem {
    @NotNull
    public ItemStack getItemStack();

    public int getLevel();

    public void setLevel(int var1);

    public double getXp();

    public void setXp(double var1);

    public int getLastHandledReward();

    public void setLastHandledReward(int var1);

    default public double getMaxXp() {
        CompiledExpression formula = LevelToolsPlugin.getInstance().getLevelXpFormula();
        double nextXpRequirement = LevelToolsUtil.round(formula.evaluate((double)this.getLevel()), 1);
        if (nextXpRequirement <= 0.0) {
            throw new RuntimeException("The next XP requirement formula returned a value too small! Please optimize your formula.");
        }
        return nextXpRequirement;
    }

    public void enchant(Enchantment var1, int var2);

    public void modifyAttribute(String var1, double var2);
}

