/*
 * Decompiled with CFR 0.152.
 */
package me.byteful.plugin.leveltools.api;

import java.util.function.BinaryOperator;
import me.byteful.plugin.leveltools.model.LevelAndXPModel;
import org.jetbrains.annotations.NotNull;

public enum AnvilCombineMode {
    HIGHER_OF_BOTH((item1, item2) -> {
        double xp;
        int level;
        int level1 = item1.getLevel();
        int level2 = item2.getLevel();
        double xp1 = item1.getXp();
        double xp2 = item2.getXp();
        if (level1 == level2) {
            level = level1;
            xp = Math.max(xp1, xp2);
        } else {
            level = Math.max(level1, level2);
            xp = level == level1 ? xp1 : xp2;
        }
        return new LevelAndXPModel(level, xp);
    }),
    LOWER_OF_BOTH((item1, item2) -> {
        double xp;
        int level;
        int level1 = item1.getLevel();
        int level2 = item2.getLevel();
        double xp1 = item1.getXp();
        double xp2 = item2.getXp();
        if (level1 == level2) {
            level = level1;
            xp = Math.min(xp1, xp2);
        } else {
            level = Math.min(level1, level2);
            xp = level == level1 ? xp1 : xp2;
        }
        return new LevelAndXPModel(level, xp);
    }),
    ADD_BOTH((item1, item2) -> {
        int level1 = item1.getLevel();
        int level2 = item2.getLevel();
        double xp1 = item1.getXp();
        double xp2 = item2.getXp();
        return new LevelAndXPModel(level1 + level2, xp1 + xp2);
    });

    @NotNull
    private final BinaryOperator<LevelAndXPModel> handler;

    private AnvilCombineMode(BinaryOperator<LevelAndXPModel> handler) {
        this.handler = handler;
    }

    @NotNull
    public static AnvilCombineMode fromName(@NotNull String name) {
        for (AnvilCombineMode value : AnvilCombineMode.values()) {
            if (!value.name().equalsIgnoreCase(name.replace(" ", "_"))) continue;
            return value;
        }
        return ADD_BOTH;
    }

    @NotNull
    public BinaryOperator<LevelAndXPModel> getHandler() {
        return this.handler;
    }

    public String toString() {
        return "AnvilCombineMode{handler=" + this.handler + '}';
    }
}

