/*
 * Decompiled with CFR 0.152.
 */
package com.floorplugins.blockban;

import com.floorplugins.blockban.WorldConfig;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class BlockBan
extends JavaPlugin
implements Listener {
    private final Map<String, WorldConfig> worldConfigs = new HashMap<String, WorldConfig>();
    private String globalBannedMessage;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigValues();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    private void loadConfigValues() {
        FileConfiguration cfg = this.getConfig();
        this.globalBannedMessage = cfg.getString("default-banned-message", "<red>You cannot place that block!</red>");
        ConfigurationSection worlds = cfg.getConfigurationSection("worlds");
        if (worlds != null) {
            for (String worldName : worlds.getKeys(false)) {
                ConfigurationSection worldSection = worlds.getConfigurationSection(worldName);
                if (worldSection == null) continue;
                String worldMessage = worldSection.getString("banned-message", null);
                ConfigurationSection bannedBlocksSection = worldSection.getConfigurationSection("banned-blocks");
                HashMap<Material, String> bannedBlocks = new HashMap<Material, String>();
                if (bannedBlocksSection != null) {
                    for (String blockName : bannedBlocksSection.getKeys(false)) {
                        Material mat = Material.getMaterial((String)blockName.toUpperCase());
                        if (mat == null) continue;
                        String blockMsg = bannedBlocksSection.getConfigurationSection(blockName).getString("banned-message", null);
                        bannedBlocks.put(mat, blockMsg);
                    }
                }
                this.worldConfigs.put(worldName, new WorldConfig(worldMessage, bannedBlocks));
            }
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Material placed = event.getBlockPlaced().getType();
        String worldName = event.getBlock().getWorld().getName();
        WorldConfig worldConfig = this.worldConfigs.get(worldName);
        WorldConfig serverConfig = this.worldConfigs.get("__server__");
        boolean isBanned = false;
        String message = null;
        if (worldConfig != null && worldConfig.bannedBlocks.containsKey(placed)) {
            isBanned = true;
            message = worldConfig.bannedBlocks.get(placed);
            if (message == null) {
                message = worldConfig.worldBannedMessage;
            }
        } else if (serverConfig != null && serverConfig.bannedBlocks.containsKey(placed)) {
            isBanned = true;
            message = serverConfig.bannedBlocks.get(placed);
            if (message == null) {
                message = this.globalBannedMessage;
            }
        }
        if (isBanned) {
            event.setCancelled(true);
            BlockState previous = event.getBlockReplacedState();
            event.getBlock().setType(previous.getType(), false);
            if (message == null) {
                message = this.globalBannedMessage;
            }
            MiniMessage mm = MiniMessage.miniMessage();
            Component msg = mm.deserialize((Object)message);
            event.getPlayer().sendMessage(msg);
        }
    }
}

