/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.vitalVials.Managers;

import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.potion.PotionEffectType;

public class EffectDataManager {
    private final String id;
    private final boolean enabled;
    private final String name;
    private final String effect;
    private final String keyValue;
    private final NamespacedKey effectKey;
    private final PotionEffectType potionEffectType;
    private final String lore;
    private final int maxLevel;
    private final boolean particles;
    private final boolean saveEffectData;
    private final String priceType;
    private final double refundPercentage;
    private final boolean autoActivate;
    private final List<Integer> durationPerUpgrade;
    private final List<Integer> cooldownPerUpgrade;
    private final List<Integer> costPerUpgrade;

    public EffectDataManager(String id, ConfigurationSection section) {
        this.id = id;
        this.enabled = section.getBoolean("enabled", true);
        this.name = section.getString("name", id);
        this.effect = section.getString("effect", "");
        this.keyValue = this.effect.toLowerCase();
        this.effectKey = NamespacedKey.minecraft((String)this.keyValue);
        this.potionEffectType = (PotionEffectType)Registry.EFFECT.get(this.effectKey);
        this.lore = section.getString("lore", "");
        this.maxLevel = section.getInt("maxLevel", 1);
        this.particles = section.getBoolean("particles", false);
        this.saveEffectData = section.getBoolean("saveEffectData", true);
        this.priceType = section.getString("priceType", "MAX_HEALTH");
        this.refundPercentage = section.getDouble("refundPercentage", 50.0);
        this.autoActivate = section.getBoolean("autoActivate", true);
        this.durationPerUpgrade = section.getIntegerList("durationPerUpgrade");
        this.cooldownPerUpgrade = section.getIntegerList("cooldownPerUpgrade");
        this.costPerUpgrade = section.getIntegerList("costPerUpgrade");
        this.validateEffect();
    }

    public void validateEffect() {
        if (this.potionEffectType == null) {
            throw new IllegalArgumentException("effect must be a valid potion effect:\u00a7c " + this.id + " (" + this.effect + ")");
        }
        if (!this.saveEffectData && !this.autoActivate) {
            throw new IllegalArgumentException("autoActivate must be true if saveEffectData is false:\u00a7c " + this.id);
        }
        if (!this.priceType.equals("MAX_HEALTH") && !this.priceType.equals("HEALTH")) {
            throw new IllegalArgumentException("priceType must be MAX_HEALTH or HEALTH:\u00a7c " + this.id + " (" + this.priceType + ")");
        }
        if (this.durationPerUpgrade.size() != this.maxLevel) {
            throw new IllegalArgumentException("durationPerUpgrade must have the same size as maxLevel:\u00a7c " + this.id + " (" + this.maxLevel + ")");
        }
        if (this.cooldownPerUpgrade.size() != this.maxLevel) {
            throw new IllegalArgumentException("cooldownPerUpgrade must have the same size as maxLevel:\u00a7c " + this.id + " (" + this.maxLevel + ")");
        }
        if (this.costPerUpgrade.size() != this.maxLevel) {
            throw new IllegalArgumentException("costPerUpgrade must have the same size as maxLevel:\u00a7c " + this.id + " (" + this.maxLevel + ")");
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getEffect() {
        return this.effect;
    }

    public String getKeyValue() {
        return this.keyValue;
    }

    public NamespacedKey getEffectKey() {
        return this.effectKey;
    }

    public PotionEffectType getPotionEffectType() {
        return this.potionEffectType;
    }

    public String getLore() {
        return this.lore;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public boolean hasParticles() {
        return this.particles;
    }

    public boolean isSaveEffectData() {
        return this.saveEffectData;
    }

    public String getPriceType() {
        return this.priceType;
    }

    public double getRefundPercentage() {
        return this.refundPercentage;
    }

    public double getRefundPercent() {
        return this.refundPercentage / 100.0;
    }

    public boolean getAutoActivate() {
        return this.autoActivate;
    }

    public List<Integer> getDurationUpgrade() {
        return this.durationPerUpgrade;
    }

    public int getDurationPerUpgrade(int level) {
        return this.durationPerUpgrade.get(level);
    }

    public List<Integer> getCooldownUpgrade() {
        return this.cooldownPerUpgrade;
    }

    public int getCooldownPerUpgrade(int level) {
        return this.cooldownPerUpgrade.get(level);
    }

    public List<Integer> getCostUpgrade() {
        return this.costPerUpgrade;
    }

    public int getCostPerUpgrade(int level) {
        return this.costPerUpgrade.get(level);
    }

    public int getCostFromTo(int from, int to) {
        int cost = 0;
        int i = from;
        while (i < to) {
            cost += this.costPerUpgrade.get(++i).intValue();
        }
        return cost;
    }
}

