/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.vitalVials.Managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;

public class DataManager {
    private final JavaPlugin plugin;
    private final Gson gson;
    private final File dataFolder;
    private final Map<UUID, Boolean> scoreboardStatusCache = new HashMap<UUID, Boolean>();

    public DataManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.dataFolder = new File(plugin.getDataFolder(), "EffectPlayers");
        if (!this.dataFolder.exists() && !this.dataFolder.mkdirs()) {
            throw new RuntimeException("Failed to create data directory: " + this.dataFolder.getAbsolutePath());
        }
    }

    public Map<String, Integer> getPlayerEffectData(UUID playerId) {
        File playerFile = this.getPlayerFile(playerId);
        HashMap<String, Integer> effects = new HashMap<String, Integer>();
        if (playerFile.exists()) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(playerFile), StandardCharsets.UTF_8);){
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                if (json.has("effects")) {
                    JsonObject effectsObj = json.getAsJsonObject("effects");
                    for (String effect : effectsObj.keySet()) {
                        effects.put(effect, effectsObj.get(effect).getAsInt());
                    }
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to load data player: " + String.valueOf(playerId), e);
            }
        }
        return effects;
    }

    public boolean isScoreboardEnabled(UUID playerId) {
        return this.scoreboardStatusCache.getOrDefault(playerId, true);
    }

    public void loadScoreboardStatusFromFile(UUID playerId) {
        File playerFile = this.getPlayerFile(playerId);
        this.syncOrderWithEffects(playerId);
        boolean enabled = true;
        if (playerFile.exists()) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(playerFile), StandardCharsets.UTF_8);){
                JsonObject scoreboardObj;
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                if (json.has("scoreboard") && (scoreboardObj = json.getAsJsonObject("scoreboard")).has("enabled")) {
                    enabled = scoreboardObj.get("enabled").getAsBoolean();
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to read scoreboard for player: " + String.valueOf(playerId), e);
            }
        }
        this.scoreboardStatusCache.put(playerId, enabled);
    }

    public List<String> getScoreboardOrder(UUID playerId) {
        File playerFile = this.getPlayerFile(playerId);
        ArrayList<String> order = new ArrayList<String>();
        if (playerFile.exists()) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(playerFile), StandardCharsets.UTF_8);){
                JsonObject scoreboardObj;
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                if (json.has("scoreboard") && (scoreboardObj = json.getAsJsonObject("scoreboard")).has("order")) {
                    for (JsonElement el : scoreboardObj.getAsJsonArray("order")) {
                        order.add(el.getAsString());
                    }
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to read scoreboard order for player: " + String.valueOf(playerId), e);
            }
        }
        return order;
    }

    public void savePlayerEffectData(UUID playerId, Map<String, Integer> effects) {
        File playerFile = this.getPlayerFile(playerId);
        JsonObject root = new JsonObject();
        JsonObject effectsObj = new JsonObject();
        for (Map.Entry<String, Integer> entry : effects.entrySet()) {
            effectsObj.addProperty(entry.getKey(), (Number)entry.getValue());
        }
        root.add("effects", (JsonElement)effectsObj);
        if (playerFile.exists()) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(playerFile), StandardCharsets.UTF_8);){
                JsonObject existingJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                if (existingJson.has("scoreboard")) {
                    root.add("scoreboard", existingJson.get("scoreboard"));
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to preserve scoreboard data when saving effects for player: " + String.valueOf(playerId), e);
            }
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(playerFile), StandardCharsets.UTF_8);){
            this.gson.toJson((JsonElement)root, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save data player: " + String.valueOf(playerId), e);
        }
        this.syncOrderWithEffects(playerId);
    }

    public void setScoreboardEnabled(UUID playerId, boolean enabled) {
        JsonObject root;
        File playerFile = this.getPlayerFile(playerId);
        if (playerFile.exists()) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(playerFile), StandardCharsets.UTF_8);){
                root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to load existing data to set scoreboard", e);
                root = new JsonObject();
            }
        } else {
            root = new JsonObject();
        }
        if (!root.has("effects")) {
            root.add("effects", (JsonElement)new JsonObject());
        }
        JsonObject scoreboardObj = root.has("scoreboard") ? root.getAsJsonObject("scoreboard") : new JsonObject();
        scoreboardObj.addProperty("enabled", Boolean.valueOf(enabled));
        root.add("scoreboard", (JsonElement)scoreboardObj);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(playerFile), StandardCharsets.UTF_8);){
            this.gson.toJson((JsonElement)root, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save scoreboard data for player: " + String.valueOf(playerId), e);
        }
        this.scoreboardStatusCache.put(playerId, enabled);
    }

    public void setScoreboardOrder(UUID playerId, List<String> order) {
        JsonObject root;
        File playerFile = this.getPlayerFile(playerId);
        if (playerFile.exists()) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(playerFile), StandardCharsets.UTF_8);){
                root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to load existing data to set scoreboard order", e);
                root = new JsonObject();
            }
        } else {
            root = new JsonObject();
        }
        if (!root.has("effects")) {
            root.add("effects", (JsonElement)new JsonObject());
        }
        JsonObject scoreboardObj = root.has("scoreboard") ? root.getAsJsonObject("scoreboard") : new JsonObject();
        JsonArray orderArr = new JsonArray();
        for (String effect : order) {
            orderArr.add(effect);
        }
        scoreboardObj.add("order", (JsonElement)orderArr);
        root.add("scoreboard", (JsonElement)scoreboardObj);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(playerFile), StandardCharsets.UTF_8);){
            this.gson.toJson((JsonElement)root, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save scoreboard order for player: " + String.valueOf(playerId), e);
        }
    }

    public void syncOrderWithEffects(UUID playerId) {
        Map<String, Integer> effects = this.getPlayerEffectData(playerId);
        List<String> order = this.getScoreboardOrder(playerId);
        Set<String> effectNames = effects.keySet();
        for (String effect2 : effectNames) {
            if (order.contains(effect2)) continue;
            order.add(effect2);
        }
        order.removeIf(effect -> !effectNames.contains(effect));
        this.setScoreboardOrder(playerId, order);
    }

    public void updatePlayerEffect(UUID playerId, String effectName, int level) {
        Map<String, Integer> effects = this.getPlayerEffectData(playerId);
        effects.put(effectName, level);
        this.savePlayerEffectData(playerId, effects);
    }

    public int getPlayerEffectLevel(UUID playerId, String effectName) {
        Map<String, Integer> effects = this.getPlayerEffectData(playerId);
        return effects.getOrDefault(effectName, -1);
    }

    public void removePlayerEffect(UUID playerId, String effectName) {
        Map<String, Integer> effects = this.getPlayerEffectData(playerId);
        if (effects.containsKey(effectName)) {
            effects.remove(effectName);
            this.savePlayerEffectData(playerId, effects);
        }
    }

    private File getPlayerFile(UUID playerId) {
        return new File(this.dataFolder, playerId.toString() + ".json");
    }

    public boolean deletePlayerData(UUID playerId) {
        File playerFile = this.getPlayerFile(playerId);
        if (playerFile.exists()) {
            return playerFile.delete();
        }
        return false;
    }

    public boolean removeAllData() {
        try {
            File[] files = this.dataFolder.listFiles((dir, name) -> name.endsWith(".json"));
            if (files != null) {
                int count = files.length;
                int deleted = 0;
                for (File file : files) {
                    if (!file.delete()) continue;
                    ++deleted;
                }
                return deleted == count;
            }
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to remove all death data", e);
            return false;
        }
    }
}

