/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.vitalVials.Listeners;

import io.github.b4n9z.vitalVials.Commands.ShopCommand;
import io.github.b4n9z.vitalVials.Managers.TransactionManager;
import io.github.b4n9z.vitalVials.VitalVials;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class InventoryGUIClickListener
implements Listener {
    private final VitalVials plugin;
    private final ShopCommand shopCommand;
    private final NamespacedKey itemKey;
    private final NamespacedKey saveTxnKey;

    public InventoryGUIClickListener(VitalVials plugin) {
        this.plugin = plugin;
        this.shopCommand = new ShopCommand(plugin);
        this.itemKey = new NamespacedKey((Plugin)plugin, "vvShortItem_b4n9z");
        this.saveTxnKey = new NamespacedKey((Plugin)plugin, "vvSaveItemTransaction_b4n9z");
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        InventoryView view = event.getView();
        if (view.getTitle().equals(String.valueOf(ChatColor.BLACK) + "VitalVials Shop") || view.getTitle().equals(String.valueOf(ChatColor.BLACK) + "VitalVials Confirm Buy")) {
            event.setCancelled(true);
            this.shopCommand.handleShopClick(player, event.getCurrentItem());
        }
        if (view.getTitle().equals(String.valueOf(ChatColor.BLACK) + "VitalVials Scoreboard Sorting")) {
            event.setCancelled(true);
            Inventory inv = event.getInventory();
            int rawSlot = event.getRawSlot();
            int size = inv.getSize();
            int saveSlot = size - 1;
            if (rawSlot < 0 || rawSlot >= size) {
                return;
            }
            if (rawSlot == saveSlot) {
                ItemStack item = event.getCurrentItem();
                if (item == null || !item.hasItemMeta()) {
                    return;
                }
                ItemMeta meta = item.getItemMeta();
                if (meta == null) {
                    return;
                }
                String txnId = (String)meta.getPersistentDataContainer().get(this.saveTxnKey, PersistentDataType.STRING);
                if (txnId != null && TransactionManager.isValidTransaction((CommandSender)player, txnId)) {
                    this.saveOrderAndClose(player, inv);
                } else {
                    player.sendMessage("\u00a7cNo active transaction to cancel or invalid transaction ID.");
                }
                TransactionManager.closeTransaction((CommandSender)player);
                return;
            }
            ClickType click = event.getClick();
            if (click != ClickType.LEFT && click != ClickType.RIGHT) {
                return;
            }
            ItemStack clicked = inv.getItem(rawSlot);
            if (clicked == null) {
                return;
            }
            ItemMeta meta = clicked.getItemMeta();
            if (meta == null) {
                return;
            }
            String effectId = (String)meta.getPersistentDataContainer().get(this.itemKey, PersistentDataType.STRING);
            if (effectId == null) {
                return;
            }
            if (click == ClickType.LEFT) {
                int target = rawSlot - 1;
                if (target >= 0 && target != saveSlot) {
                    this.swap(inv, rawSlot, target);
                }
            } else {
                int target = rawSlot + 1;
                if (target < saveSlot) {
                    this.swap(inv, rawSlot, target);
                }
            }
        }
    }

    private void swap(Inventory inv, int a, int b) {
        ItemStack ia = inv.getItem(a);
        ItemStack ib = inv.getItem(b);
        inv.setItem(a, ib);
        inv.setItem(b, ia);
    }

    private void saveOrderAndClose(Player player, Inventory inv) {
        ArrayList<String> newOrder = new ArrayList<String>();
        int size = inv.getSize();
        int saveSlot = size - 1;
        for (int i = 0; i < size; ++i) {
            String effectId;
            ItemMeta meta;
            ItemStack it;
            if (i == saveSlot || (it = inv.getItem(i)) == null || (meta = it.getItemMeta()) == null || (effectId = (String)meta.getPersistentDataContainer().get(this.itemKey, PersistentDataType.STRING)) == null || effectId.isBlank()) continue;
            newOrder.add(effectId);
        }
        this.plugin.getDataManager().setScoreboardOrder(player.getUniqueId(), newOrder);
        this.plugin.getDataManager().syncOrderWithEffects(player.getUniqueId());
        this.plugin.getCustomScoreboardManager().updateScoreboard(player);
        player.closeInventory();
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Scoreboard order saved.");
    }
}

