/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.vitalVials.Listeners;

import io.github.b4n9z.vitalVials.Managers.EffectDataManager;
import io.github.b4n9z.vitalVials.VitalVials;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.projectiles.ProjectileSource;

public class EntityDamageByEntityListener
implements Listener {
    private final VitalVials plugin;

    public EntityDamageByEntityListener(VitalVials plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Projectile projectile;
        ProjectileSource projectileSource;
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        if (event.isCancelled()) {
            return;
        }
        Entity attacker = event.getDamager();
        Player attackerPlayer = null;
        Material weapon = Material.AIR;
        if (attacker instanceof Player) {
            Player player;
            attackerPlayer = player = (Player)attacker;
            weapon = player.getInventory().getItemInMainHand().getType();
        } else if (attacker instanceof Projectile && (projectileSource = (projectile = (Projectile)attacker).getShooter()) instanceof Player) {
            Player shooter;
            attackerPlayer = shooter = (Player)projectileSource;
            Projectile projectile2 = projectile;
            Objects.requireNonNull(projectile2);
            projectileSource = projectile2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Arrow.class, Trident.class, Snowball.class, Egg.class}, (Object)projectileSource, n)) {
                case 0: {
                    Arrow ignored = (Arrow)projectileSource;
                    weapon = Material.ARROW;
                    break;
                }
                case 1: {
                    Trident ignored = (Trident)projectileSource;
                    weapon = Material.TRIDENT;
                    break;
                }
                case 2: {
                    Snowball ignored = (Snowball)projectileSource;
                    weapon = Material.SNOWBALL;
                    break;
                }
                case 3: {
                    Egg ignored = (Egg)projectileSource;
                    weapon = Material.EGG;
                    break;
                }
            }
        }
        if (attackerPlayer != null) {
            this.applyEffects(attackerPlayer, target, weapon, "YouAreHittingEnemy");
            if (target instanceof Player) {
                Player targetPlayer = (Player)target;
                this.applyEffects(targetPlayer, (LivingEntity)attackerPlayer, weapon, "enemyHitYou");
            }
        } else if (attacker instanceof LivingEntity) {
            LivingEntity destroyer = (LivingEntity)attacker;
            if (target instanceof Player) {
                Player targetPlayer = (Player)target;
                EntityEquipment equipment = destroyer.getEquipment();
                if (equipment != null) {
                    weapon = equipment.getItemInMainHand().getType();
                }
                this.applyEffects(targetPlayer, destroyer, weapon, "enemyHitYou");
            }
        }
    }

    private void applyEffects(Player sourcePlayer, LivingEntity target, Material weapon, String triggerType) {
        Map<String, Integer> playerEffects = this.plugin.getDataManager().getPlayerEffectData(sourcePlayer.getUniqueId());
        for (Map.Entry<String, Integer> entry : playerEffects.entrySet()) {
            String effectKey = entry.getKey();
            int level = entry.getValue();
            EffectDataManager effect = this.plugin.getConfigManager().getEffects().get(effectKey);
            if (effect.getAutoActivate()) continue;
            boolean allTools = this.plugin.getConfigManager().isAllToolsForEffect(effect, triggerType);
            boolean rightTool = this.plugin.getConfigManager().isRightToolForEffect(weapon, effect, triggerType);
            if (!allTools && !rightTool) continue;
            this.plugin.getEffectManager().applyEffectToTarget(sourcePlayer, target, effectKey, level);
        }
    }
}

