/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.vitalVials.Commands;

import io.github.b4n9z.vitalVials.Managers.EffectDataManager;
import io.github.b4n9z.vitalVials.VitalVials;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ViewStatusCommand
implements CommandExecutor {
    private final VitalVials plugin;

    public ViewStatusCommand(VitalVials plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.plugin.getConfigManager().canUse((CommandSender)player, "viewStatus")) {
                UUID uuidPlayer = player.getUniqueId();
                Map<String, Integer> playerEffects = this.plugin.getDataManager().getPlayerEffectData(uuidPlayer);
                for (Map.Entry<String, Integer> entry : playerEffects.entrySet()) {
                    String effectKey = entry.getKey();
                    EffectDataManager effectInfo = this.plugin.getConfigManager().getEffects().get(effectKey);
                    if (!effectInfo.isEnabled()) continue;
                    int level = entry.getValue();
                    int cooldown = effectInfo.getCooldownPerUpgrade(level);
                    int duration = effectInfo.getDurationPerUpgrade(level);
                    Object durationString = duration + "s";
                    if (duration == -1) {
                        durationString = "infinite";
                    }
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "||===]>" + String.valueOf(ChatColor.RED) + effectKey + String.valueOf(ChatColor.GREEN) + "<[===||");
                    player.sendMessage(String.valueOf(ChatColor.WHITE) + effectInfo.getLore());
                    player.sendMessage(String.valueOf(ChatColor.BLUE) + "\u300b" + String.valueOf(ChatColor.WHITE) + "Level : " + String.valueOf(ChatColor.LIGHT_PURPLE) + (level + 1));
                    player.sendMessage(String.valueOf(ChatColor.BLUE) + "\u300b" + String.valueOf(ChatColor.WHITE) + "Duration : " + String.valueOf(ChatColor.LIGHT_PURPLE) + (String)durationString);
                    player.sendMessage(String.valueOf(ChatColor.BLUE) + "\u300b" + String.valueOf(ChatColor.WHITE) + "Cooldown : " + String.valueOf(ChatColor.LIGHT_PURPLE) + cooldown + "s");
                    player.sendMessage(String.valueOf(ChatColor.BLUE) + "\u300b" + String.valueOf(ChatColor.WHITE) + "Max Level Upgrade : " + String.valueOf(ChatColor.LIGHT_PURPLE) + effectInfo.getMaxLevel());
                    player.sendMessage(String.valueOf(ChatColor.RED) + " (" + effectInfo.getPriceType() + " \u25c8 " + (effectInfo.isSaveEffectData() ? "Data Saved" : "Data Not Saved") + " \u25c8 " + (String)(effectInfo.getRefundPercentage() < 0.0 ? "Cannot Refund" : effectInfo.getRefundPercentage() + "% Refund") + ")");
                    player.sendMessage(String.valueOf(ChatColor.WHITE) + "[+]======[ACTIVATION]======[+]");
                    if (this.plugin.getConfigManager().getEffects().get(effectKey).getAutoActivate()) {
                        player.sendMessage(String.valueOf(ChatColor.BLUE) + " \u226b " + String.valueOf(ChatColor.AQUA) + " Auto Activated : " + String.valueOf(ChatColor.LIGHT_PURPLE) + "true");
                    }
                    if (this.plugin.getConfigManager().hasActivationTypes(effectInfo, "rightClick")) {
                        player.sendMessage(String.valueOf(ChatColor.BLUE) + " \u226b " + String.valueOf(ChatColor.AQUA) + " Applied to Yourself When Right Click Using: " + String.valueOf(ChatColor.LIGHT_PURPLE) + this.plugin.getConfigManager().getActivationTypes(effectInfo).get("rightClick"));
                    }
                    if (this.plugin.getConfigManager().hasActivationTypes(effectInfo, "leftClick")) {
                        player.sendMessage(String.valueOf(ChatColor.BLUE) + " \u226b " + String.valueOf(ChatColor.AQUA) + " Applied to Yourself When Left Click Using: " + String.valueOf(ChatColor.LIGHT_PURPLE) + this.plugin.getConfigManager().getActivationTypes(effectInfo).get("leftClick"));
                    }
                    if (this.plugin.getConfigManager().hasActivationTypes(effectInfo, "YouAreHittingEnemy")) {
                        player.sendMessage(String.valueOf(ChatColor.BLUE) + " \u226b " + String.valueOf(ChatColor.AQUA) + " Applied to Enemies When You Hit an Enemy Using : " + String.valueOf(ChatColor.LIGHT_PURPLE) + this.plugin.getConfigManager().getActivationTypes(effectInfo).get("YouAreHittingEnemy"));
                    }
                    if (this.plugin.getConfigManager().hasActivationTypes(effectInfo, "enemyHitYou")) {
                        player.sendMessage(String.valueOf(ChatColor.BLUE) + " \u226b " + String.valueOf(ChatColor.AQUA) + " Applied to Enemy When Enemy Hits You Using : " + String.valueOf(ChatColor.LIGHT_PURPLE) + this.plugin.getConfigManager().getActivationTypes(effectInfo).get("enemyHitYou"));
                    }
                    player.sendMessage(String.valueOf(ChatColor.WHITE) + "||==========================||");
                    player.sendMessage("");
                }
                return true;
            }
        }
        return true;
    }
}

