/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.vitalVials.Commands;

import io.github.b4n9z.vitalVials.Managers.EffectDataManager;
import io.github.b4n9z.vitalVials.Managers.HealthManager;
import io.github.b4n9z.vitalVials.Managers.TransactionManager;
import io.github.b4n9z.vitalVials.VitalVials;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BuyEffectCommand
implements CommandExecutor {
    private final VitalVials plugin;

    public BuyEffectCommand(VitalVials plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.plugin.getConfigManager().canUse((CommandSender)player, "buyEffect")) {
                int targetLevel;
                if (args.length < 2) {
                    sender.sendMessage("\u00a7fUsage:\u00a7c /VitalVials\u00a7b buyEffect\u00a7f <effectName> [level]");
                    return true;
                }
                TransactionManager.closeTransaction((CommandSender)player);
                String effectName = args[1];
                EffectDataManager effectInfo = this.plugin.getConfigManager().getEffects().get(effectName);
                if (effectInfo == null || !effectInfo.isEnabled()) {
                    player.sendMessage(String.valueOf(ChatColor.WHITE) + "Invalid effect name: " + String.valueOf(ChatColor.RED) + effectName);
                    return true;
                }
                int currentLevel = this.plugin.getDataManager().getPlayerEffectLevel(player.getUniqueId(), effectName);
                if (args.length == 3) {
                    try {
                        targetLevel = Integer.parseInt(args[2]) - 1;
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid level number: " + args[2]);
                        return true;
                    }
                } else {
                    targetLevel = currentLevel + 1;
                }
                if (targetLevel <= currentLevel) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You already have level " + currentLevel + "1 or higher for this effect!");
                    return true;
                }
                if (targetLevel > effectInfo.getMaxLevel() - 1) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "The maximum level for this effect is " + effectInfo.getMaxLevel() + "!");
                    return true;
                }
                this.confirmBuy(player, effectInfo, targetLevel);
                return true;
            }
        }
        return true;
    }

    private void confirmBuy(Player player, EffectDataManager effectInfo, int targetLevel) {
        if (this.plugin.getConfigManager().canUse((CommandSender)player, "buyEffect")) {
            if (!effectInfo.isEnabled()) {
                return;
            }
            String transactionId = TransactionManager.generateTransactionId((CommandSender)player, "buyEffect");
            TransactionManager.openTransaction(this.plugin, (CommandSender)player, transactionId);
            String effectKey = effectInfo.getId();
            int currentLevel = this.plugin.getDataManager().getPlayerEffectLevel(player.getUniqueId(), effectKey);
            int price = effectInfo.getCostFromTo(currentLevel, targetLevel);
            String healthType = effectInfo.getPriceType().equals("MAX_HEALTH") ? " Max" : "";
            int cooldown = effectInfo.getCooldownPerUpgrade(targetLevel);
            int duration = effectInfo.getDurationPerUpgrade(targetLevel);
            Object durationString = duration == -1 ? "infinite" : duration + "s";
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "||===]>" + String.valueOf(ChatColor.RED) + effectInfo.getName() + String.valueOf(ChatColor.GREEN) + "<[===||");
            player.sendMessage(String.valueOf(ChatColor.WHITE) + effectInfo.getLore());
            player.sendMessage(String.valueOf(ChatColor.BLUE) + "\u300b" + String.valueOf(ChatColor.WHITE) + "Level : " + String.valueOf(ChatColor.LIGHT_PURPLE) + (targetLevel + 1));
            player.sendMessage(String.valueOf(ChatColor.BLUE) + "\u300b" + String.valueOf(ChatColor.WHITE) + "Price : " + String.valueOf(ChatColor.LIGHT_PURPLE) + price / 2 + healthType + " Hearts \u2764 \u00a7f/\u00a7c " + price + healthType + " Health Points \u2665");
            player.sendMessage(String.valueOf(ChatColor.BLUE) + "\u300b" + String.valueOf(ChatColor.WHITE) + "Duration : " + String.valueOf(ChatColor.LIGHT_PURPLE) + (String)durationString);
            player.sendMessage(String.valueOf(ChatColor.BLUE) + "\u300b" + String.valueOf(ChatColor.WHITE) + "Cooldown : " + String.valueOf(ChatColor.LIGHT_PURPLE) + cooldown + "s");
            player.sendMessage(String.valueOf(ChatColor.BLUE) + "\u300b" + String.valueOf(ChatColor.WHITE) + "Max Level Upgrade : " + String.valueOf(ChatColor.LIGHT_PURPLE) + effectInfo.getMaxLevel());
            player.sendMessage(String.valueOf(ChatColor.RED) + " (" + effectInfo.getPriceType() + " \u25c8 " + (effectInfo.isSaveEffectData() ? "Data Saved" : "Data Not Saved") + " \u25c8 " + (String)(effectInfo.getRefundPercentage() < 0.0 ? "Cannot Refund" : effectInfo.getRefundPercentage() + "% Refund") + ")");
            player.sendMessage(String.valueOf(ChatColor.WHITE) + "[+]======[ACTIVATION]======[+]");
            if (this.plugin.getConfigManager().getEffects().get(effectKey).getAutoActivate()) {
                player.sendMessage(String.valueOf(ChatColor.BLUE) + " \u226b " + String.valueOf(ChatColor.AQUA) + " Auto Activated : " + String.valueOf(ChatColor.LIGHT_PURPLE) + "true");
            }
            if (this.plugin.getConfigManager().hasActivationTypes(effectInfo, "rightClick")) {
                player.sendMessage(String.valueOf(ChatColor.BLUE) + " \u226b " + String.valueOf(ChatColor.AQUA) + " Applied to Yourself When Right Click Using: " + String.valueOf(ChatColor.LIGHT_PURPLE) + this.plugin.getConfigManager().getActivationTypes(effectInfo).get("rightClick"));
            }
            if (this.plugin.getConfigManager().hasActivationTypes(effectInfo, "leftClick")) {
                player.sendMessage(String.valueOf(ChatColor.BLUE) + " \u226b " + String.valueOf(ChatColor.AQUA) + " Applied to Yourself When Left Click Using: " + String.valueOf(ChatColor.LIGHT_PURPLE) + this.plugin.getConfigManager().getActivationTypes(effectInfo).get("leftClick"));
            }
            if (this.plugin.getConfigManager().hasActivationTypes(effectInfo, "YouAreHittingEnemy")) {
                player.sendMessage(String.valueOf(ChatColor.BLUE) + " \u226b " + String.valueOf(ChatColor.AQUA) + " Applied to Enemies When You Hit an Enemy Using : " + String.valueOf(ChatColor.LIGHT_PURPLE) + this.plugin.getConfigManager().getActivationTypes(effectInfo).get("YouAreHittingEnemy"));
            }
            if (this.plugin.getConfigManager().hasActivationTypes(effectInfo, "enemyHitYou")) {
                player.sendMessage(String.valueOf(ChatColor.BLUE) + " \u226b " + String.valueOf(ChatColor.AQUA) + " Applied to Enemy When Enemy Hits You Using : " + String.valueOf(ChatColor.LIGHT_PURPLE) + this.plugin.getConfigManager().getActivationTypes(effectInfo).get("enemyHitYou"));
            }
            player.sendMessage(String.valueOf(ChatColor.WHITE) + "||==========================||");
            TextComponent message = new TextComponent("\u00a7fAre\u00a7b you\u00a7f sure\u00a7b you\u00a7f want to buy/upgrade\u00a7e " + effectKey + " \u00a7f to level\u00a7b " + String.valueOf(ChatColor.RED) + (targetLevel + 1) + String.valueOf(ChatColor.WHITE) + " \u00a7f for\u00a7b " + String.valueOf(ChatColor.RED) + price / 2 + healthType + " Hearts \u2764 \u00a7f/\u00a7c " + price + healthType + " Health Points \u2665\u00a7f? ");
            TextComponent yes = new TextComponent("[YES]");
            yes.setColor(net.md_5.bungee.api.ChatColor.GREEN);
            yes.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/vitalvials confirmBuy " + String.valueOf(player.getUniqueId()) + " " + effectKey + " " + transactionId + " " + targetLevel));
            TextComponent no = new TextComponent("[NO]");
            no.setColor(net.md_5.bungee.api.ChatColor.RED);
            no.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/vitalvials cancelBuy " + transactionId));
            TextComponent newline = new TextComponent("\n");
            message.addExtra((BaseComponent)newline);
            message.addExtra((BaseComponent)yes);
            message.addExtra(" - ");
            message.addExtra((BaseComponent)no);
            player.spigot().sendMessage((BaseComponent)message);
        }
    }

    public boolean confirmBuyCommand(CommandSender sender, String[] args) {
        if (!this.plugin.getConfigManager().canUse(sender, "buyEffect")) {
            sender.sendMessage("\u00a7fYou\u00a7c don't have permission\u00a7f to use this command.");
            return false;
        }
        if (args.length != 5) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /VitalVials\u00a7b confirmBuy\u00a7f <playerUUID> <effectName> <transactionId> <targetLevel>");
            return false;
        }
        UUID playerId = UUID.fromString(args[1]);
        Player player = this.plugin.getServer().getPlayer(playerId);
        assert (player != null);
        if (!TransactionManager.isValidTransaction((CommandSender)player, args[3])) {
            sender.sendMessage("\u00a7cThis confirmation has expired or is invalid. Please try again.");
            return false;
        }
        String effectName = args[2];
        int targetLevel = Integer.parseInt(args[4]);
        EffectDataManager effectInfo = this.plugin.getConfigManager().getEffects().get(effectName);
        Map<String, Integer> playerEffects = this.plugin.getDataManager().getPlayerEffectData(playerId);
        try {
            if (effectInfo == null || !effectInfo.isEnabled()) {
                player.sendMessage(String.valueOf(ChatColor.WHITE) + "Invalid effect name: " + String.valueOf(ChatColor.RED) + effectName);
                return true;
            }
            int currentLevel = this.plugin.getDataManager().getPlayerEffectLevel(playerId, effectName);
            if (targetLevel <= currentLevel) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You already have this level or higher!");
                return true;
            }
            int price = effectInfo.getCostFromTo(currentLevel, targetLevel);
            String healthType = effectInfo.getPriceType().equals("MAX_HEALTH") ? " Max" : "";
            double currentHealth = HealthManager.getHealth(player);
            double currentMaxHealth = HealthManager.getMaxHealth(player);
            double newHealth = currentHealth - (double)price;
            double newMaxHealth = currentMaxHealth - (double)price;
            if (effectInfo.getPriceType().equals("MAX_HEALTH") && (currentMaxHealth < (double)price || newMaxHealth <= this.plugin.getConfigManager().getMinHPValue()) || !effectInfo.getPriceType().equals("MAX_HEALTH") && (currentHealth < (double)price || newHealth <= this.plugin.getConfigManager().getMinHPValue())) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have enough" + healthType + " health to buy/upgrade " + String.valueOf(ChatColor.AQUA) + effectName + String.valueOf(ChatColor.WHITE) + " for " + String.valueOf(ChatColor.RED) + price / 2 + healthType + " Hearts \u2764 \u00a7f/\u00a7c " + price + healthType + " Health Points \u2665\u00a7f!");
                return true;
            }
            if (targetLevel > effectInfo.getMaxLevel() - 1) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You have reached the maximum level for this effect!");
                return true;
            }
            playerEffects.put(effectName, targetLevel);
            if (effectInfo.getPriceType().equals("MAX_HEALTH")) {
                HealthManager.setMaxHealth(newMaxHealth, player);
            } else {
                HealthManager.setHealth(newHealth, player);
            }
            if (effectInfo.isSaveEffectData()) {
                this.plugin.getDataManager().savePlayerEffectData(playerId, playerEffects);
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.getEffectManager().applyAllEffects(player), 5L);
            } else {
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.getEffectManager().applyEffect(player, effectName, targetLevel), 5L);
            }
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You bought/upgraded " + String.valueOf(ChatColor.AQUA) + effectName + String.valueOf(ChatColor.WHITE) + " to level " + String.valueOf(ChatColor.LIGHT_PURPLE) + (targetLevel + 1) + String.valueOf(ChatColor.WHITE) + " for " + String.valueOf(ChatColor.RED) + price / 2 + healthType + " Hearts \u2764 \u00a7f/\u00a7c " + price + healthType + " Health Points \u2665\u00a7f!");
            this.plugin.sendColoredMessageToConsole("\u00a7b" + player.getName() + "\u00a7f has bought/upgraded " + String.valueOf(ChatColor.AQUA) + effectName + String.valueOf(ChatColor.WHITE) + " to level " + String.valueOf(ChatColor.LIGHT_PURPLE) + (targetLevel + 1) + String.valueOf(ChatColor.WHITE) + " for " + String.valueOf(ChatColor.RED) + price / 2 + healthType + " Hearts \u2764 \u00a7f/\u00a7c " + price + healthType + " Health Points \u2665\u00a7f!");
            TransactionManager.closeTransaction((CommandSender)player);
        }
        catch (Exception e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to buy/upgrade effect: " + String.valueOf(ChatColor.WHITE) + e.getMessage());
        }
        return true;
    }

    public boolean cancelBuyCommand(CommandSender sender, String[] args) {
        if (args.length != 2) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /VitalVials\u00a7b cancelBuy\u00a7f <transactionId>");
            return false;
        }
        String transactionId = args[1];
        if (!transactionId.isEmpty() && TransactionManager.isValidTransaction(sender, transactionId)) {
            TransactionManager.closeTransaction(sender);
            sender.sendMessage("\u00a7bBuy Effect\u00a7f has been\u00a7c cancelled.");
        } else {
            sender.sendMessage("\u00a7cNo active transaction to cancel or invalid transaction ID.");
        }
        return true;
    }
}

